# -*- coding:utf-8 -*-
from PyQt4 import QtCore, QtGui ,QtWebKit
from PyQt4 import uic
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtWebKit import *
from PyQt4 import QtXmlPatterns
from PyQt4.QtNetwork import *
from qsphere_tools import *
from qsphere_objmaker import *
import os.path
import os
import codecs

from PyQt4.QtNetwork import QNetworkAccessManager, QNetworkReply, QNetworkRequest

class Ui_Dialog(object):
    def setupUi(self, Dialog):
        self._W, self._H = 900, 680
        Dialog.setMinimumSize(QtCore.QSize(self._W,self._H))
        Dialog.resize(QtCore.QSize(QtCore.QRect(0,0,self._W,self._H).size()).expandedTo(Dialog.minimumSizeHint()))
        Dialog.setWindowFlags(Qt.WindowMaximizeButtonHint)
        self.initDir = ""

        zSizeW = Dialog.width()-20
        zSizeH = Dialog.height()-50
        self.fileExtension = ".html"

        self.HTML = ""
        self.barInfo = QgsMessageBar(Dialog)
        self.barInfo.setSizePolicy( QSizePolicy.Minimum, QSizePolicy.Fixed )
                
        self.labeleURL = QLabel(Dialog)
        self.labeleURL.setGeometry(QtCore.QRect(10, 15,  50, 25))
        self.labeleURL.setText("URL : ")
        self.labeleURL.setAlignment(Qt.AlignRight)
      
        self.eURL = MyWidgetLineEdit(Dialog)
        self.eURL.initType(4)
        QtCore.QObject.connect(self.eURL,QtCore.SIGNAL("textChanged(const QString &)"),self.eURL.VerifExpReg)

        self.tabWidget = QtGui.QTabWidget(Dialog)
        self.tabWidget.setObjectName("tabWidget")
        self.tabWidget.setStyleSheet(
            """QTabBar::tab:selected {color: #5D5D5D;background-color: rgb(255,255,255);}"""
            """QTabBar::tab:!selected {color: rgb(255,255,255);background-color: #5D5D5D;border-bottom-color: #5D5D5D;}"""
            """QTabWidget:pane {margin: 1px,1px,1px,1px;background-color: rgb(255,255,255);}"""
            """QTabBar::tab {border: 0px solid rgb(0,149,48);border-bottom-color: rgb(255,255,255);border-top-left-radius: 0px;border-top-right-radius: 0px;height: 20px;width: 170px;background-color: rgb(255,255,255);}"""
            """QTabWidget{background-color: rgb(255,255,255);font: 75 10pt "Arial Rounded MT Bold";}"""
            """QTabWidget::tab-bar {left: 5px; bottom: -1px;background-color: rgb(255,255,255); } """
            """QTabBar::scroller {width: 0px;}"""
        )
        self.tabWidget.setTabPosition(QtGui.QTabWidget.South) 
        self.tabWidget.setTabShape(QtGui.QTabWidget.Rounded)
        self.tabWidget.setUsesScrollButtons(True)
        
        zTitle = ("Page", \
                  QtGui.QApplication.translate("QSphere", "Analyzer", None, QtGui.QApplication.UnicodeUTF8))
        zToolTip = (QtGui.QApplication.translate("QSphere", "HTML page for help", None, QtGui.QApplication.UnicodeUTF8), \
                    QtGui.QApplication.translate("QSphere", "HTML page analyzer", None, QtGui.QApplication.UnicodeUTF8))
        self.myPathIconvRightArrow, self.myPathIconvLeftArrow = "rightarrow.png", "leftarrow.png"
        self.myPathHome, self. myPathGoURL = "home.png", "gourl.png"
        self.myPathLoadXML, self.myPathLoadHTML = "loadxml.png", "loadxml.png"
        self.myPathPrint, self.myPathLoadFiles, self.myPathSave = "print.png", "open.png", "save.png"
        self.myReloadPage = "reloadpage.png"

        for i in range(1,len(zTitle)+1):
            zTab = QtGui.QWidget(Dialog)
            zTab.setObjectName("tab%s" % (i))
            zTab.setAccessibleName(zTitle[i-1])
            self.tabWidget.addTab(zTab, zTitle[i-1])
            self.tabWidget.setTabToolTip(i-1, zToolTip[i-1])

            if i == 1:
                viewHTML = WebView(zTab)
                viewHTML.initWebView(Dialog)
                viewHTML.setGeometry(QtCore.QRect(0, 0, zSizeW-25, zSizeH-85))
                viewHTML.setObjectName("viewHTML")
                viewHTML.setAccessibleName("viewHTML")
                viewHTML.settings().setAttribute(QWebSettings.JavascriptEnabled, True)
                viewHTML.settings().setAttribute(QWebSettings.DeveloperExtrasEnabled, True)
                viewHTML.settings().setAttribute(QWebSettings.LinksIncludedInFocusChain, True)
                viewHTML.setRenderHints(QPainter.Antialiasing | QPainter.SmoothPixmapTransform)
                viewHTML.page().setLinkDelegationPolicy(QtWebKit.QWebPage.DelegateAllLinks)
                viewHTML.page().setForwardUnsupportedContent(True)
                self.viewHTML = viewHTML
            elif i == 2:
                inspector = QtWebKit.QWebInspector(zTab)
                inspector.setGeometry(QtCore.QRect(0, 0, zSizeW-25, zSizeH-85))
                inspector.setPage(self.viewHTML.page())
                inspector.show()
                inspector.setVisible(True)
                self.inspector = inspector
               

        self.BackButton = MyPushButton(Dialog)
        self.BackButton.initPushButton(24, 24, 5, 5, "BackButton", "", QtGui.QApplication.translate("QSphere", "Previous page", None, QtGui.QApplication.UnicodeUTF8), True, getThemeIcon(self.myPathIconvLeftArrow), 24, 24, True)

        self.FowardButton = MyPushButton(Dialog)
        self.FowardButton.initPushButton(24, 24, 5, 5, "FowardButton", "", QtGui.QApplication.translate("QSphere", "Next page", None, QtGui.QApplication.UnicodeUTF8), True, getThemeIcon(self.myPathIconvRightArrow), 24, 24, True)


        self.goURL = MyPushButton(Dialog)
        self.goURL.initPushButton(24, 24, 5, 5, "goURL", "", QtGui.QApplication.translate("QSphere", "Go url", None, QtGui.QApplication.UnicodeUTF8), True, getThemeIcon(self.myPathGoURL), 24, 24, True)

        self.AccueilButton = MyPushButton(Dialog)
        self.AccueilButton.initPushButton(24, 24, 5, 5, "AccueilButton", "", QtGui.QApplication.translate("QSphere", "Home page", None, QtGui.QApplication.UnicodeUTF8), True, getThemeIcon(self.myPathHome), 24, 24, True)

        self.ReloadButton = MyPushButton(Dialog)
        self.ReloadButton.initPushButton(24, 24, 5, 5, "ReloadButton", "", QtGui.QApplication.translate("QSphere", "Reload page", None, QtGui.QApplication.UnicodeUTF8), True, getThemeIcon(self.myReloadPage), 24, 24, True)

        self.LoadButton = MyPushButton(Dialog)
        self.LoadButton.initPushButton(24, 24, 5, 5, "LoadButton", "", QtGui.QApplication.translate("QSphere", "Open Files", None, QtGui.QApplication.UnicodeUTF8), True, getThemeIcon(self.myPathLoadFiles), 24, 24, True)

        self.PrintButton = MyPushButton(Dialog)
        self.PrintButton.initPushButton(24, 24, 5, 5, "PrintButton", "", QtGui.QApplication.translate("QSphere", "Print", None, QtGui.QApplication.UnicodeUTF8), True, getThemeIcon(self.myPathPrint), 24, 24, True)
                
        self.SaveButton = MyPushButton(Dialog)
        self.SaveButton.initPushButton(24, 24, 5, 5, "SaveButton", "", QtGui.QApplication.translate("QSphere", "Save XML as HTML File", None, QtGui.QApplication.UnicodeUTF8), True, getThemeIcon(self.myPathSave), 24, 24, True)
        
        self.CloseButton = QtGui.QPushButton(Dialog)
        self.CloseButton.setObjectName("CloseButton")
        self.CloseButton.setText(QtGui.QApplication.translate("QSphere", "Close", None, QtGui.QApplication.UnicodeUTF8))

        QtCore.QObject.connect(self.PrintButton,QtCore.SIGNAL("clicked()"), self.printhelp)
        QtCore.QObject.connect(self.BackButton,QtCore.SIGNAL("clicked()"), self.go_back)
        QtCore.QObject.connect(self.AccueilButton,QtCore.SIGNAL("clicked()"), self.go_accueil)
        QtCore.QObject.connect(self.goURL,QtCore.SIGNAL("clicked()"), self.go_url)
        QtCore.QObject.connect(self.ReloadButton,QtCore.SIGNAL("clicked()"), self.reloadPageURL)
        self.contextMnuLoadData()
        QtCore.QObject.connect(self.FowardButton,QtCore.SIGNAL("clicked()"), self.go_forward)
        QtCore.QObject.connect(self.CloseButton,QtCore.SIGNAL("clicked()"), self.close)
        QtCore.QObject.connect(viewHTML, QtCore.SIGNAL("urlChanged(QUrl)"), self.changePageURL)
        QtCore.QObject.connect(self.SaveButton, QtCore.SIGNAL("clicked()"), self.SaveHTML)
       
        self.go_accueil()

    def close(self): self.reject()
        
    def contextMnuLoadData(self):
        contextMnu_LoadData = QMenu()

        zIcon = getThemeIcon(self.myPathLoadXML)
        zText = QtGui.QApplication.translate("QSphere","Open metadata XML ISO 19139 ...", None, QtGui.QApplication.UnicodeUTF8)
        self.LoadXML = QAction(QIcon(zIcon), zText, self)
        contextMnu_LoadData.addAction(self.LoadXML)
        QObject.connect(self.LoadXML, SIGNAL("triggered()"),self.loadfileXML)
        
        contextMnu_LoadData.addSeparator()
        
        zIcon = getThemeIcon(self.myPathLoadHTML)
        zText = QtGui.QApplication.translate("QSphere","Open QSphere's HTML files ...", None, QtGui.QApplication.UnicodeUTF8)
        self.loadHTML = QAction(QIcon(zIcon), zText, self)
        contextMnu_LoadData.addAction(self.loadHTML)
        QObject.connect(self.loadHTML,SIGNAL("triggered()"),self.loadfileHTML)
        
        self.LoadButton.setMenu(contextMnu_LoadData)


    def printhelp(self):
        printer = QPrinter() 
        printer.setPageSize(QPrinter.A4)
        printer.setOrientation(QPrinter.Portrait) if self.isXML else printer.setOrientation(QPrinter.Landscape)
        printer.setPageMargins(5, 10, 5, 10, QPrinter.Millimeter) if self.fileExtension == ".xml" else printer.setPageMargins(10, 10, 10, 10, QPrinter.Millimeter)
        printer.setOutputFormat(QPrinter.NativeFormat)
        printDialog = QPrintPreviewDialog(printer)
        MakeWindowIcon(printDialog, self.myPathPrint)
        printDialog.setWindowTitle(QtGui.QApplication.translate("QSphere", "Print current page", None, QtGui.QApplication.UnicodeUTF8))
        printDialog.setWindowFlags(Qt.WindowMaximizeButtonHint)
        printDialog.paintRequested.connect(self.viewHTML.print_)
        printDialog.exec_()     

    def resizeEvent(self,ev):
        zSize = ev.size()
        self.barInfo.setGeometry(0, zSize.height()-40, zSize.width()-130, 40)
        self.BackButton.setGeometry(65, 10, 25, 25)
        self.eURL.setGeometry(95, 10,  zSize.width()-320, 25)
        self.FowardButton.setGeometry(zSize.width()-220, 10, 60, 25)
        self.goURL.setGeometry(zSize.width()-190, 10, 60, 25)
        self.AccueilButton.setGeometry(zSize.width()-160, 10, 60, 25)
        self.ReloadButton.setGeometry(zSize.width()-130, 10, 60, 25)
        self.LoadButton.setGeometry(zSize.width()-100, 10, 60, 25)
        self.PrintButton.setGeometry(zSize.width()-70, 10, 60, 25)
        self.SaveButton.setGeometry(zSize.width()-40, 10, 60, 25)
        
        self.tabWidget.setGeometry(QtCore.QRect(10, 40,  zSize.width()-20, zSize.height()-90))
        self.viewHTML.setGeometry(QtCore.QRect(0, 0,  zSize.width()-25, zSize.height()-105))
        self.inspector.setGeometry(QtCore.QRect(0, 0,  zSize.width()-25, zSize.height()-105))
        
        self.CloseButton.setGeometry(QtCore.QRect(zSize.width()-120, zSize.height()-30, 100, 25))
        
    def reloadPageURL(self):
        self.viewHTML.pageAction(QtWebKit.QWebPage.Reload)
        self.go_url()
        
    def go_back(self):
        self.viewHTML.history().back()
        zUrl = "%s" % (unicode(self.viewHTML.history().currentItem().url().toString()))
        self.eURL.setText(zUrl)
        FixeEnabledHistory(self, self.viewHTML)
        
    def go_forward(self):
        self.viewHTML.history().forward()
        zUrl = "%s" % (unicode(self.viewHTML.history().currentItem().url().toString()))
        self.eURL.setText(zUrl)        
        FixeEnabledHistory(self, self.viewHTML)

    def SaveHTML(self):
        InitDir = os.path.dirname(self.eURL.text()) if self.initDir == "" else self.initDir
        InitDir = CorrigePath(InitDir)
        fileName, fileExtension = os.path.splitext(self.eURL.text())
        NameFile = os.path.basename(self.eURL.text())
        InitDir = "%s%s%s" % (InitDir,NameFile.rsplit(".",1)[0], ".html")
        fileName = QFileDialog.getSaveFileName(None, QtGui.QApplication.translate("QSphere","Save as a HTML file", None, QtGui.QApplication.UnicodeUTF8),InitDir,"*.html")
        if fileName!="" :
            zLOG = open(fileName, "w")
            zLOG.write(self.HTML)
            if zLOG != None : zLOG.close()
      
    def go_url(self):
        zUrl = self.eURL.text()
        if zUrl.find("file:")==-1 and zUrl.find("filexml:")==-1 and zUrl.find("about:")==-1 :
            if zUrl[0:7] != "http://" : self.eURL.setText("http://%s" % (zUrl))
            
        if self.eURL.text() != "" and self.eURL.styleSheet()!="background-color:red;" :
            ActiveLink(self, self.eURL.text(), False, self.viewHTML)
        else :
            zMsg = QtGui.QApplication.translate("QSphere","URL not natively supported ! Use open function if necessary for local ressources ...", None, QtGui.QApplication.UnicodeUTF8)
            SendMessage(self, "information" , zMsg, QgsMessageBar.WARNING, 5)
            
    def loadfileXML(self):
        InitDir = os.path.dirname(__file__) if self.initDir == "" else self.initDir
        fileName = QFileDialog.getOpenFileName(None, QtGui.QApplication.translate("QSphere","View a file XML ISO 19139", None, QtGui.QApplication.UnicodeUTF8),InitDir,"*.xml")
        if fileName!="" :
           ActiveLink(self, "filexml:%s" % (fileName), False, self.viewHTML)
           self.setWindowTitle(fileName)
           self.initDir = os.path.dirname(fileName)

    def loadfileHTML(self):
        InitDir = "%s/%s" % (os.path.dirname(__file__), "ressources/html")
        fileName = QFileDialog.getOpenFileName(None, QtGui.QApplication.translate("QSphere","View a HTML file", None, QtGui.QApplication.UnicodeUTF8),InitDir,"*.html;;*.htm")
        if fileName!="" :
           fileName = "file:%s" % (os.path.basename(fileName))
           ActiveLink(self, fileName, False, self.viewHTML)
           self.setWindowTitle(os.path.basename(fileName))
        
    def go_accueil(self):
        FixeEnabledHistory(self, self.viewHTML)
        ActiveLink(self, self.url, False, self.viewHTML)

    def changePageURL(self):
        zPage = self.viewHTML.page()
        linkact = zPage.action(QWebPage.OpenLink)


class WebView(QWebView):
    def __init__(self, parent=None):
        QWebView.__init__(self, parent)
        self.ToCopy = ""
        self.current_url = QtCore.QUrl("")
        self.fileName = self.TypeMime = None
        self.setContextMenuPolicy(Qt.CustomContextMenu)
        QtCore.QObject.connect(self,QtCore.SIGNAL('customContextMenuRequested (const QPoint&)'), self.context_menu_requested)
        QtCore.QObject.connect(self,QtCore.SIGNAL('linkClicked(const QUrl&)'), self.GoLink) #(const QUrl &), Qt.DirectConnection)
        QtCore.QObject.connect(self.page(),QtCore.SIGNAL("unsupportedContent(QNetworkReply*)"), self.unsupportedContent)

    def initWebView(self, zDialog): self.Dialog = zDialog
    
    def context_menu_requested(self, point):
        self.imageurl = None
        context_menu = QMenu()
        page = self.page()
        frame = page.currentFrame()
        if unicode(self.selectedText()):
            menuIcon = getThemeIcon("copier.png")
            zText = (QtGui.QApplication.translate("QSphere", "Copy", None, QtGui.QApplication.UnicodeUTF8))
            self.copy = context_menu.addAction(QIcon(menuIcon), zText)
            self.ToCopy = unicode(self.selectedText())
            QObject.connect(self.copy, SIGNAL("triggered()"), self.MakeToCopy)
        hit_test = frame.hitTestContent(point)
        if unicode(hit_test.linkUrl().toString()):
            menuIcon = getThemeIcon("copierlink.png")
            zText = (QtGui.QApplication.translate("QSphere", "Copy link", None, QtGui.QApplication.UnicodeUTF8))
            self.copyURL = context_menu.addAction(QIcon(menuIcon), zText)
            self.ToCopyURL = unicode(hit_test.linkUrl().toString())
            QObject.connect(self.copyURL, SIGNAL("triggered()"), self.MakeToCopyURL)

           
        menuIcon = getThemeIcon("selectall.png")
        zText = (QtGui.QApplication.translate("QSphere", "Select all", None, QtGui.QApplication.UnicodeUTF8))
        self.selall = QAction(QIcon(menuIcon), zText, self)
        context_menu.addAction(self.selall)
        QObject.connect(self.selall,SIGNAL("triggered()"),self.SelectAll)
        
        context_menu.addSeparator()
        
        menuIcon = getThemeIcon("coller.png")
        zText = (QtGui.QApplication.translate("QSphere", "Paste", None, QtGui.QApplication.UnicodeUTF8))
        self.paste = QAction(QIcon(menuIcon), zText, self)
        context_menu.addAction(self.paste)
        QObject.connect(self.paste,SIGNAL("triggered()"),self.MakeToPaste)
        
        if unicode(page.mainFrame().hitTestContent(point).element().tagName()).lower()== "img":
            self.imageurl =  page.mainFrame().hitTestContent(point).imageUrl()
            tempoSRC = page.mainFrame().hitTestContent(point).element().attribute("src")
            tempoSRC = tempoSRC.replace("\\","/")

            if tempoSRC!="" :
               self.fileName = tempoSRC.rsplit("/",1)[1]
               self.TypeMime = "*.%s" % (self.fileName.rsplit(".",1)[1])
            
            context_menu.addSeparator()

            menuIcon = getThemeIcon("saveas.png")
            zText = (QtGui.QApplication.translate("QSphere", "Save image as ...", None, QtGui.QApplication.UnicodeUTF8))
            self.downloadimg = QAction(QIcon(menuIcon), zText, self)
            context_menu.addAction(self.downloadimg)
            QObject.connect(self.downloadimg,SIGNAL("triggered()"),self.DownloadImg)

            self.paste.setEnabled(False)
   
        context_menu.exec_(self.mapToGlobal(point))

    def DownloadImg(self):
        self.telech = Telecharge(self.imageurl, self.Dialog, self.fileName, self.TypeMime)
        self.telech.fintelecharge.connect(self.telecharge_ok)


    def unsupportedContent(self, reply, outfd=None): 
        if not reply.error():
            self.telech = Telecharge(reply.url(), self.Dialog, None, None)
            self.telech.fintelecharge.connect(self.telecharge_ok)
        else :
            zMsg = QtGui.QApplication.translate("QSphere","Error on unsupported content :", None, QtGui.QApplication.UnicodeUTF8)
            SendMessage(self.Dialog, "information" , "%s %s" % (zMsg, reply.errorString()), QgsMessageBar.WARNING, 5)


    def telecharge_ok(self, ok):
        if ok:
            zMsg = QtGui.QApplication.translate("QSphere","Donwload success ! File save as :", None, QtGui.QApplication.UnicodeUTF8)
            SendMessage(self.Dialog, "information" , "%s %s" % (zMsg, self.fileNameSaveImg), QgsMessageBar.INFO, 1)
        else:
            zMsg = QtGui.QApplication.translate("QSphere","Donwload error ! File not save ...", None, QtGui.QApplication.UnicodeUTF8)
            SendMessage(self.Dialog, "information" , zMsg, QgsMessageBar.WARNING, 2)


    def MakeToCopy(self): QApplication.clipboard().setText(self.ToCopy)
    def MakeToCopyURL(self): QApplication.clipboard().setText(self.ToCopyURL)
    def MakeToPaste(self): self.page().triggerAction(QWebPage.Paste)
    def SelectAll(self): self.page().triggerAction(QWebPage.SelectAll)
    def GoLink(self, url):
        self.current_url = url
        ActiveLink(self.Dialog,self.current_url, True, self)


def FixeEnabledHistory(zDialog, MyWebView):
    zDialog.BackButton.setEnabled(True) if MyWebView.history().backItems(100) else zDialog.BackButton.setEnabled(False)
    zDialog.FowardButton.setEnabled(True) if MyWebView.history().forwardItems(100)  else zDialog.FowardButton.setEnabled(False)
    
def ActiveLink(zDialog, zUrl, isUnicode, MyWebView) :
        zPath = getThemeIcon(os.path.dirname(__file__))
        zAnchor = zDialog.HTML = ""
        if isUnicode : zUrl = "%s" % (unicode(zUrl.toString()))
        zDialog.eURL.setText(zUrl)
        if zUrl.find("xml:")!=-1 or zUrl.find("file:")!=-1 : zDialog.eURL.setStyleSheet("background-color:#AEEE00;")
        zDialog.fileExtension, zDialog.isXML, zDialog.iconName, zDialog.DefaultTitle = ".html", False, "qsp.png",  zUrl
     
        if zUrl.find("file:")!=-1 :
           zDialog.iconName, zDialog.DefaultTitle = "info.png", QtGui.QApplication.translate("QSphere", "Help about Metadata with INSPIRE", None, QtGui.QApplication.UnicodeUTF8) 
           zUrl = zUrl.replace("file:","")
           if zUrl.find(".html#")!= -1 :
              zTemp = zUrl.split("#")
              zUrl = zTemp[0]
              zAnchor = zTemp[1]
           MyWebView.setStyleSheet("background-color:rgb(255,255,255); padding: 7px ; color:rgb(255,255,255)")
           zFileHelp = zPath +"/ressources/html/" + zUrl 
           if os.path.exists(zFileHelp) :
               zText = ""

               if zDialog.emprise!=[]: sEmprise = "<script>var bounds = new OpenLayers.Bounds(%s, %s, %s, %s);</script>" % (zDialog.emprise[2], zDialog.emprise[1], zDialog.emprise[3], zDialog.emprise[0])
               else : sEmprise = "<script>var bounds = new OpenLayers.Bounds(-9.6199999999999992, 41.18, 10.300000000000001, 51.539999999999999);</script>"

               f = codecs.open(zFileHelp, encoding='cp1252')
               for line in f: zText+= line
               if zText.find("[%SCRIPT_EMPRISE%]")!= -1: zText = zText.replace("[%SCRIPT_EMPRISE%]", sEmprise)
               if zText.find("[%DIR%]")!= - 1: zText = zText.replace("[%DIR%]",zPath + "/icons/")
               if zText.find("[%CSS%]")!= - 1: zText = zText.replace("[%CSS%]",zPath + "/ressources/html/")
               if zText.find("[%IMG%]")!= - 1: zText = zText.replace("[%IMG%]",zPath + "/ressources/html/images/")
               if zText.find("[%LOADER(IMAGES)%]")!= - 1:
                  zList = ""
                  zList = listdirectory(MyWebView.parent(), zPath +"/icons/")
                  zText = zText.replace("[%LOADER(IMAGES)%]",zList)
               MyWebView.setHtml(zText)
               if zAnchor != "" :
                   zTest = MyWebView.findText(zAnchor)
                   if not zTest : MyWebView.page().mainFrame().scrollToAnchor(zAnchor) 
               f.close()
           else : MyWebView.setHtml(QtGui.QApplication.translate("QSphere", "Resource file missing !", None, QtGui.QApplication.UnicodeUTF8))
        elif zUrl.find("filexml:")!=-1 :
            zDialog.isXML = True
            zUrl = zUrl.replace("filexml:","")
            overrideLocale = QSettings().value("locale/overrideFlag", False)
            localeFullName = QLocale.system().name() if not overrideLocale else QSettings().value("locale/userLocale", "")
            Lang = "fr" if localeFullName[0:2]=="fr" else "en"

            zDialog.initDir = CorrigePath(os.path.dirname(zUrl))
            fileName, zDialog.fileExtension = os.path.splitext(zUrl)

            if zDialog.fileExtension.lower() == ".xml" :
                from PyQt4.QtXml import *
                from PyQt4.QtXmlPatterns  import * 

                qry = QXmlQuery(QXmlQuery.XSLT20)
                XSL = "%s/xml/xsl/transformation_%s.xsl" % (getThemeIcon(os.path.dirname(__file__)), Lang)
                
                qry.setFocus(QUrl.fromLocalFile(zUrl)) 
                qry.setQuery(QUrl.fromLocalFile(XSL)) 
                HTML = qry.evaluateToString()

                if HTML is None:
                   XSL = "%s/xml/xsl/iso19115_%s.xsl" % (getThemeIcon(os.path.dirname(__file__)), Lang)
                   qry.setFocus(QUrl.fromLocalFile(zUrl))
                   qry.setQuery(QUrl.fromLocalFile(XSL))
                   HTML = qry.evaluateToString()
                   if HTML is None:
                      HTML = QtGui.QApplication.translate("QSphere", "Resource file parsing error !", None, QtGui.QApplication.UnicodeUTF8) 
                else:
                   #QXmlPattern not support CDATA section
                   HTML = HTML.replace('&amp;', '&')
                   HTML = HTML.replace('&gt;', '>')
                   HTML = HTML.replace('&lt;', '<')
                MyWebView.setHtml(HTML)
                zDialog.HTML = HTML

        elif zUrl.find("redmineqsphere:")!=-1 :
            zMsg = QtGui.QApplication.translate("QSphere","Try to open Web navigator for https protocol ...", None, QtGui.QApplication.UnicodeUTF8)
            SendMessage(zDialog, "information" , zMsg, QgsMessageBar.WARNING, 3)
            zDialog.eURL.setStyleSheet("background-color:#AEEE00;")
            try  : os.startfile("https://qgis.projets.developpement-durable.gouv.fr/projects/qsphere")
            except : pass
               
        else :
            zDialog.DefaultTitle = QtGui.QApplication.translate("QSphere", "Web navigation", None, QtGui.QApplication.UnicodeUTF8)
            if QUrl(zUrl).isValid() :
               zDialog.eURL.setStyleSheet("background-color:#AEEE00;")
               MyWebView.load(QUrl(zUrl))
            else :
               zMsg = QtGui.QApplication.translate("QSphere","Invalid URL ! Use open function if necessary for local ressources ...", None, QtGui.QApplication.UnicodeUTF8)
               SendMessage(zDialog, "information" , zMsg, QgsMessageBar.WARNING, 5)

        zDialog.SaveButton.setEnabled(True) if zDialog.HTML!="" else zDialog.SaveButton.setEnabled(False)

        FixeEnabledHistory(zDialog, MyWebView)    
        MakeWindowIcon(zDialog, zDialog.iconName)
        zDialog.setWindowTitle(zDialog.DefaultTitle)
        page = MyWebView.page()
        page.setLinkDelegationPolicy(QtWebKit.QWebPage.DelegateAllLinks)
        

class Telecharge(QNetworkAccessManager):
    fintelecharge = QtCore.pyqtSignal(bool)
    def __init__(self, url, dialog, fileName, typeMime) : 
        QNetworkAccessManager.__init__(self)
        self.initDir = CorrigePath(os.path.dirname(__file__))
        self.Dialog = dialog
        self.messageBuffer = QtCore.QByteArray()
        self.fileName, self.typeMime = fileName, typeMime
        self.reply = self.get(QNetworkRequest(url))
        self.reply.readyRead.connect(self.readData)
        self.reply.finished.connect(self.finished)

    @QtCore.pyqtSlot()
    def readData(self):
        self.messageBuffer+= self.reply.readAll()
        zMsg = QtGui.QApplication.translate("QSphere","Read from download stream ", None, QtGui.QApplication.UnicodeUTF8) 
        SendMessage(self.Dialog, "information" , "%s (%s bytes) %s" % (zMsg, len(self.messageBuffer), self.reply.url()), QgsMessageBar.INFO, 2)
 
    @QtCore.pyqtSlot()
    def finished(self):
        #For image
        filtermime = "*.*" if self.typeMime == None else self.typeMime
        initDir = self.initDir if self.fileName == None else "%s%s" % (self.initDir, self.fileName)
        #For XML
        if filtermime == "*.*" :
           typemime, filtermime = "%s" % (self.reply.header(0)), "*.*"
           if typemime.find(";")!=-1 :
               typemime = typemime.rsplit(";",1)[0]
               if typemime.find("/")!=-1 :
                  filtermime = "*.%s" % (typemime.rsplit("/",1)[1].lower()) 

        if filtermime == "*.xml" : 
            import xml.etree.ElementTree as ET
            from cStringIO import StringIO

            dataXML = StringIO(self.messageBuffer)
            tree = ET.parse(dataXML)
            root = tree.getroot()
         
            if root.tag == '{http://www.isotc211.org/2005/gmd}MD_Metadata':
               from xmlISOparser import *
               myISO = xmlISOparser(None, StringIO(self.messageBuffer), 'MEDDE', 'fr') 
               myISO.createISOdataStructure()

               self.fileName = "%s.xml" % (myISO.fileIdentifier[0][0]) if myISO.fileIdentifier[0][0]!="" else "*.xml"
               initDir = "%s%s" % (self.initDir, self.fileName)
        

        fileName = QFileDialog.getSaveFileName(None, QtGui.QApplication.translate("QSphere","Save file as ...", None, QtGui.QApplication.UnicodeUTF8), initDir, filtermime)
        if fileName!="" :
            self.initDir = os.path.dirname(fileName)
            saveFile = QtCore.QFile(fileName)
            if (saveFile.open(QtCore.QIODevice.WriteOnly)):
                saveFile.write(self.messageBuffer)
                saveFile.close()
                zMsg = QtGui.QApplication.translate("QSphere","Download finished :", None, QtGui.QApplication.UnicodeUTF8) 
                SendMessage(self.Dialog, "information" , "%s %s" % (zMsg, self.reply.url()), QgsMessageBar.INFO, 2)
                self.fintelecharge.emit(True)
            else:
                zMsg = QtGui.QApplication.translate("QSphere","Network error on download :", None, QtGui.QApplication.UnicodeUTF8) 
                SendMessage(self.Dialog, "information" , "%s %s" % (zMsg, self.reply.url()), QgsMessageBar.INFO, 2)
                self.fintelecharge.emit(False)
