# -*- coding:utf-8 -*- 
import sys

from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *

import doUI
from qsphere_tools import *

class MainPlugin(object):
  toolBarName = "qsphere"
  
  def __init__(self, iface):
    self.name = "qsphere"
    self.iface = iface

    overrideLocale = QSettings().value("locale/overrideFlag", False)
    localeFullName = QLocale.system().name() if not overrideLocale else QSettings().value("locale/userLocale", "")
    self.localePath = os.path.dirname(__file__) + "/i18n/qsphere_" + localeFullName[0:2] + ".qm"
    self.localeFullName = localeFullName
    self.langueTR = localeFullName[0:2]
    self.languesDico = getisocodes_dict('ISO-639-2_utf-8.txt')
    self.langue, self.langueIndex = getUILangIndex(self)

    #if self.langueTR in ("fr", "it", "es","de") :
    #if self.langueTR == "fr" :
    #TOTO 2.6.1
    reload(sys)
    sys.setdefaultencoding('iso-8859-1')
       
    if QFileInfo(self.localePath).exists():
       self.translator = QTranslator()
       self.translator.load(self.localePath)
       QCoreApplication.installTranslator(self.translator)

  def initGui(self):
    self.menu=QMenu("QSPHERE")

    menuIcon = getThemeIcon("qsp.png")
    zText = QtGui.QApplication.translate("QSphere","Admin metadata ...", None, QtGui.QApplication.UnicodeUTF8)
    self.metadata = QAction(QIcon(menuIcon), zText,self.iface.mainWindow())
    self.metadata.setText(zText)

    menuIcon = getThemeIcon("help.png")
    zText = QtGui.QApplication.translate("QSphere","Call the help page", None, QtGui.QApplication.UnicodeUTF8)
    self.help = QAction(QIcon(menuIcon), zText, self.iface.mainWindow())
    self.help.setText(zText)

    menuIcon = getThemeIcon("about.png")
    zText = QtGui.QApplication.translate("QSphere","About ...", None, QtGui.QApplication.UnicodeUTF8)
    self.about = QAction(QIcon(menuIcon), zText, self.iface.mainWindow())
    self.about.setText(zText)

    self.menu.addAction(self.metadata)
    self.menu.addAction(self.help)
    self.menu.addSeparator()
    self.menu.addAction(self.about)

    menuBar = self.iface.mainWindow().menuBar()
    zMenu = menuBar
    for child in menuBar.children():
        if child.objectName()== "mPluginMenu" :
           zMenu =  child
           break
    zMenu.addMenu(self.menu)

    toolbar = self.iface.addToolBar(self.toolBarName)
    self._toolbar = toolbar

    toolbar.addAction(self.metadata)
    toolbar.addAction(self.help)
    toolbar.addSeparator()
    toolbar.addAction(self.about)

    QObject.connect(self.metadata,SIGNAL("triggered()"),self.clickMetaData)
    QObject.connect(self.help,SIGNAL("triggered()"),self.clickHelp)
    QObject.connect(self.about,SIGNAL("triggered()"),self.clickAbout)  

    self.formats = MakeListFormats(self)
    self.langs = MakeListLangs(self)
    self.listCodecs = MakeListEncoders(self)
    self.listTemporalSystem = MakeListTemporalSystem(self)
    self.listTypeRessources = MakeListTypeRessources(self)
    self.listCountries, self.indexCountry, self.listCountriesCode = MakeListCountries(self)

  def clickHelp(self):
        zLang = "fr" if self.langueTR == "fr" else "en"
        zUrl = "file:helpIHM_"+ zLang +".html"
        d = doUI.DialogViewer(self.iface, zUrl, False, []) 
        d.exec_()
        
  def clickAbout(self):
        zLang = "fr" if self.langueTR == "fr" else "en"
        zUrl = "file:apropos_"+ zLang +".html"
        d = doUI.DialogViewer(self.iface, zUrl, False, [])  
        d.exec_()

  def clickMetaData(self):
    d = doUI.DialogMetadata(self.iface, self.langue, self.langueIndex, self.langs, self.languesDico, \
                            self.langueTR, self.formats, self.listCodecs, self.listTemporalSystem, \
                            self.listTypeRessources, self.listCountries, self.indexCountry, self.listCountriesCode, self.localeFullName)
    d.exec_()
      
  def unload(self): pass
        


