
from xml.etree import ElementTree as ET
import urllib,os,sys

class xmlISOparser:
	def __init__(self, filenameIP, dataXML, isoFormat, langue):				
		self.inputXMLfile = filenameIP
		self.dataXML = dataXML
		self.isoFormatToExtract = isoFormat
		self.langueTR = langue

		
	def createISOdataStructure(self):
                if self.dataXML == None and self.inputXMLfile == None : return False
                else : self.root = self.getIsoXML(self.inputXMLfile, self.dataXML)
		if self.root is None : return False
		
		self.importISOxmlDefinition(self.isoFormatToExtract)
		
		self.fileIdentifier = self.getElementVal(self.isoModel.fileIdentifier())
		self.title = self.getElementVal(self.isoModel.title())
		self.abstract = self.getElementVal(self.isoModel.abstract())
		self.typedata = self.getElementVal(self.isoModel.typedata())
		self.localisators = self.getElementVal(self.isoModel.localisators())
		self.tablecarac = self.getElementVal(self.isoModel.tablecarac())
		self.identificator = self.getElementVal(self.isoModel.identificator())
                self.languesjdd = self.getElementVal(self.isoModel.languesjdd())
                self.categories = self.getElementVal(self.isoModel.categories())
                self.keywordsF = self.getElementVal(self.isoModel.keywordsF())
                self.keywordsFNC = self.getElementVal(self.isoModel.keywordsFNC())
                self.timeperiodes = self.getElementVal(self.isoModel.timeperiodes())
                self.dates = self.getElementVal(self.isoModel.dates())
		self.formatsjdd = self.getElementVal(self.isoModel.formatsjdd())
		self.boundingboxcoordinates = self.getElementVal(self.isoModel.boundingboxcoordinates())
		self.scr = self.getElementVal(self.isoModel.scr())
		self.genealogie = self.getElementVal(self.isoModel.genealogie())
		self.coherence = self.getElementVal(self.isoModel.coherence())
		self.scalesEC = self.getElementVal(self.isoModel.scalesEC())
		self.scalesUM = self.getElementVal(self.isoModel.scalesUM())
		self.UnitsScalesUM = self.getElementVal(self.isoModel.UnitsScalesUM())
                self.conformities = self.getElementVal(self.isoModel.conformities())
		self.legalconstraints = self.getElementVal(self.isoModel.legalconstraints())
		self.accessconstraints = self.getElementVal(self.isoModel.accessconstraints())
		self.otherconstraints = self.getElementVal(self.isoModel.otherconstraints())
		self.authors = self.getElementVal(self.isoModel.authors())
		self.pointsofcontact = self.getElementVal(self.isoModel.pointsofcontact())
		self.pointsofcontactMDD = self.getElementVal(self.isoModel.pointsofcontactMDD())
		self.pointsofcontactCust  = self.getElementVal(self.isoModel.pointsofcontactCust())
		self.languemdd = self.getElementVal(self.isoModel.languemdd())
		self.datetmdd = self.getElementVal(self.isoModel.datetmdd())
		self.datemdd = self.getElementVal(self.isoModel.datemdd())
		
		return True
	

	def boundingDateRange(self,boundingDatesList):
		allDates, returnDates = [], {}
		for outer in boundingDatesList:
			for inner in outer.keys():
				if outer[inner] is not None:
					if outer[inner] != 'None': allDates.append(outer[inner])
                if allDates != []:
                    returnDates['start'] = min(allDates)
                    returnDates['end'] = max(allDates)
		return returnDates


	def importISOxmlDefinition(self,format):
		if format == 'MEDDE':
		   from xmlISOreaderTag import xmlISOreaderTag as isoModel
		self.isoModel = isoModel()
		
		
	def getElementVal(self,keyMethod):
		returnValList, returnVal, dataStruct, counter =[], 'None', {}, 0
		for i in keyMethod:
                        if type(i) is dict:
                           for j in i.keys(): dataStruct[counter]=j
                        if type(i) is str: dataStruct[counter] = i
                        counter = counter + 1
		
		valueList, ordering, cnt = [], False, 1
                zTempoData = ""

		for i in dataStruct.keys()[1:]:
			thisData = keyMethod[i][dataStruct[i]]
                        if 'basilexpath' in thisData.keys():
                                returnVal =  self.returnBaliseElt(thisData['basilexpath'])
                                valueList.append(returnVal)                                

                        if 'basilexpathvalue' in thisData.keys():
                                returnVal =  self.returnBaliseEltValue(thisData['basilexpathvalue'])
                                valueList.append(returnVal)
			
			if 'baseXpath' in thisData.keys():
				returnVal = self.returnDependantElementVal(thisData['baseXpath'],thisData['elValXpath'],thisData['depValXpath'],thisData['depVal'])
				valueList.append(returnVal)
								
			if 'xpath' in thisData.keys():
                                returnVal =  self.returnSimpleElementVal(thisData['xpath'])
                                zTempoData = thisData['xpath']
                                #valueList.append(returnVal)
                                #TOTO 2.6.1
                                if returnVal == [] and zTempoData == "gmd:contact/gmd:CI_ResponsibleParty/gmd:role/gmd:CI_RoleCode" :
                                        returnVal = self.returnDependantElementVal(thisData['baseXpath'],thisData['elValXpath'],thisData['depValXpath'],thisData['depVal'])
                                        valueList.append(returnVal)
				else : valueList.append(returnVal)
				
			if 'order' in keyMethod[i].keys(): ordering, orderingList = True, thisData				
			else: pass
			cnt = cnt + 1

		
                if [] in valueList : return valueList
		if ordering:
			checkCompLnth = len(valueList[0])
			index=0
			for list in valueList:
				if len(list) != checkCompLnth:
                                        if len(list)> checkCompLnth:
                                           zElt = ""
                                           for elt in list : zElt+= " %s" % (elt)
                                           list=[]
                                           list.append(zElt)
                                           valueList[index] = list
                                        else : return 'None'
                                if zTempoData.startswith('gmd:contact/gmd:CI_ResponsibleParty/gmd:contactInfo') or zTempoData.startswith('gmd:identificationInfo/gmd:MD_DataIdentification/gmd:pointOfContact'):
                                   if list[0]==None :
                                         list=[]
                                         if index==0 : list.append("pointOfContact")
                                         elif index==3 and self.langueTR=="fr": list.append("France")
                                         else : list.append("")
                                         valueList[index] = list                                             
                                index+=1

			outer = []
			for localPos in range(0,checkCompLnth):
				inner=[]
				for listPos in range(0,len(valueList)):	inner.append(valueList[listPos][localPos])
				outer.append(inner)
			
			for returnedList in outer:
				orderedValsSub = {}
				if len(returnedList) != len(orderingList): returnValList.append('None')
				else:		
          		            for i in orderingList.keys(): orderedValsSub[i] = returnedList[orderingList[i]-1] 
   				    returnValList.append(orderedValsSub)
			
			return returnValList
			
		else:
			return valueList
			
			

	def returnDependantElementVal(self,baseXpath,elXpath,depXpath,depValReqd):
		baseXpath = self.appendNameSpace(baseXpath)
		resDependantVal = []
		try: rootEl = self.root.findall(baseXpath) 
		except:	return 'None'

		for el in rootEl:
			thisElXpth = self.appendNameSpace(elXpath)
			thisEl = self.doFindall(el,thisElXpth)
			if thisEl != 'None':
				elVal = thisEl[0].text 
                		thisEldepXpth = self.appendNameSpace(depXpath)					
				thisDepEl = self.doFindall(el,thisEldepXpth)								
				if thisDepEl != 'None':
        				depVal = thisDepEl[0].text
			                resDependantVal.append(elVal)			
																			
		return resDependantVal

	def returnBaliseElt(self,xpath):
		xpathNS = self.appendNameSpace(xpath)
		resElementVal = []
		try: rootEl = self.root.findall(xpathNS)
		except: return ['None']
		for elVal in rootEl:
		    if elVal is None: resElementVal.append('None')
		    else:
                       if elVal.attrib == {}:
                          for childItem in elVal :
                              if childItem.tag.find("Boolean")!=-1 : resElementVal.append(childItem.text)
                       else : resElementVal.append(elVal.attrib)
                return resElementVal        

	def returnBaliseEltValue(self,xpath):
		xpathNS = self.appendNameSpace(xpath)
		resElementVal = []
		try: rootEl = self.root.findall(xpathNS)
		except: return ['None']
		for elVal in rootEl:
		    if elVal is None: resElementVal.append('None')
		    else:
                       if elVal.attrib == {}:
                          for childItem in elVal :
                              if childItem.tag.find("Boolean")!=-1 : resElementVal.append(childItem.text)
                       else : resElementVal.append(elVal.attrib['codeListValue'])
                return resElementVal
                       
		
	def returnSimpleElementVal(self,xpath):
		xpathNS = self.appendNameSpace(xpath)
		resElementVal = []
		try: rootEl = self.root.findall(xpathNS)
		except: return ['None']
		for elVal in rootEl:
			if elVal is None: resElementVal.append('None')
			else: resElementVal.append(elVal.text)
		return resElementVal

	def doFindall(self,el,thisElXpth):
		try:
			thisElXpthEl = el.findall(thisElXpth)
			if len(thisElXpthEl) == 0: thisElXpthEl = 'None'
		except: thisElXpthEl = 'None'
		return thisElXpthEl
		
		

	def getXmlVal(self,paths):
		xmlVals = []
		for path in paths:
			try: xmlVals.append(self.root.find(path).text)			
			except:	xmlVals.append('null')
		return xmlVals					
		

	def isoNameSpaces(self):
                """        
                namespaces={'om':'http://www.opengis.net/om/1.0',
                        'gml':'http://www.opengis.net/gml/3.2',
                        'swe':'http://www.opengis.net/swe/1.0.2',
                        'ioos':'http://www.noaa.gov/ioos/0.6.1',
                         'sos':'http://www.opengis.net/sos/1.0'}

                namespaces2={'om':'http://www.opengis.net/om/1.0',
                        'gml':'http://www.opengis.net/gml',
                        'swe':'http://www.opengis.net/swe/1.0.1',
                        'ioos':'http://www.noaa.gov/ioos/0.6.1',
                        'sos':'http://www.opengis.net/sos/1.0',
                        'ogc':'http://www.opengis.net/ogc',
                        'tml':'http://www.opengis.net/tml',
                        'sml':'http://www.opengis.net/sensorML/1.0.1',
                        'myorg':'http://www.myorg.org/features',
                        'xlink':'http://www.w3.org/1999/xlink'}
		"""
		isoNs = {'gmd':'http://www.isotc211.org/2005/gmd',
                         'gco':'http://www.isotc211.org/2005/gco',
			 'gmx':'http://www.isotc211.org/2005/gmx',
                         'gml':'http://www.opengis.net/gml',
			 'none':''
			 }
		return isoNs
	
	
	def defaultIsoNamespace(self):  return 'gmd'
	
	def getIsoXML(self, file, dataXML):
		etree = ET.parse(file) if file!= None else ET.parse(dataXML)
		root=etree.getroot()
		if root.tag != '{http://www.isotc211.org/2005/gmd}MD_Metadata':	return None
		return root
		
	def appendNameSpaceList(self,paths):
		nameSpaceAppendedPaths = []
		for path in paths:		
			pathElements = path.split('/')
			count = 0
			for element in pathElements:
				try:					
					if ':' in element:						
						splitElement = element.split(':')
						nsPrefix,nsElement = splitElement[0],splitElement[1]
					else:
						nsPrefix = self.defaultIsoNamespace()
						nsElement = element
					if count == 0: appendedPath = '{%s}%s' % (self.isoNameSpaces()[nsPrefix], nsElement)
					else: appendedPath = '%s/{%s}%s' % (appendedPath , self.isoNameSpaces()[nsPrefix] , nsElement)						
					count += 1
				except:	appendedPath = 'null'
							
			appendedPath = appendedPath.replace('{}','')
			nameSpaceAppendedPaths.append(appendedPath)
		return nameSpaceAppendedPaths
	

	def appendNameSpace(self,path):
		nameSpaceAppendedPath = ''
		pathElements = path.split('/')
		count = 0
		for element in pathElements:
			try:					
				if ':' in element:						
					splitElement = element.split(':')
					nsPrefix,nsElement = splitElement[0],splitElement[1]
				else:
					nsPrefix = self.defaultIsoNamespace()
					nsElement = element
				if count == 0: appendedPath = '{%s}%s' % (self.isoNameSpaces()[nsPrefix] , nsElement)
				else: appendedPath = '%s/{%s}%s' % (appendedPath , self.isoNameSpaces()[nsPrefix] , nsElement)
				count += 1
			except:	appendedPath = 'null'
		nameSpaceAppendedPath = appendedPath.replace('{}','')
		return nameSpaceAppendedPath
