# -*- coding:utf-8 -*-

try:
    from osgeo import gdal, ogr
    from osgeo import osr
    from osgeo.gdalconst import *
except:
    import gdal, ogr
    import osr

import os
import codecs
import string
import datetime
from random import sample

from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
from qsphere_objmaker import *


#=================================
# FUNCTIONS FIXE VALUE AND WIDGET
#=================================
def GetIndex(zObj):
    try : zIndexEmp = int(zObj.toolTip())
    except : zIndexEmp = -1
    if zIndexEmp == -1 : zIndexEmp = 0
    return zIndexEmp

def MakeToolTipCalendar(self, zObjCalendar):
    TheDate = ReturnDate(self, zObjCalendar)
    zMsg = QtGui.QApplication.translate("QSphere","Present Value : ", None, QtGui.QApplication.UnicodeUTF8) + TheDate 
    zObjCalendar.setToolTip(zMsg)
    return zMsg

def SetTextWidget(self, zCible, zText, isValue):
    zObj = getWidget(self, zCible)     
    if zObj!=None:
       if not isValue : zObj.setText(zText)
       else :  zObj.setValue(float(zText))

def FixeLayerType(self, layertype):
    index = int(layertype)
    ztypes = ("vector", "raster", "plugin")
    return ztypes[index]

def GetTextWidget(self, zCible, isValue):
    zObj = getWidget(self, zCible)
    zValue, zText = "", ""
    if zObj == None : return zValue, zText
    
    zClassObjName = "%s" % (zObj.metaObject().className())
    if zClassObjName in ("QLineEdit", "MyWidgetLineEdit"):    
        zValue = "%s" % (CorrigeText(zObj.text()))
        zText = "%s" % (CorrigeText(zObj.text()))
    elif zClassObjName=="QCalendarWidget" :
        zValue = ReturnDate(self, zObj)
        zText = zValue        
    elif zClassObjName=="QComboBox" :
        zValue = "%s" % (zObj.currentText())
        zValue = zValue.lower()
        zText = "%s" % (zObj.currentText())
    elif zClassObjName=="QTextEdit" :
        zValue = "%s" % (CorrigeText(zObj.toPlainText()))
        zText = zValue
    return zValue, zText

def CorrigeText(TextIn):
    TextOut = TextIn.replace('&', '&amp;')
    TextOut = TextOut.replace('>', '&gt;')
    TextOut = TextOut.replace('<', '&lt;')
    return TextOut

def getWidget(self, zCible):
    zTabs = self.tabWidget.count()
    zObj = None
    for i in range(zTabs):
        self.tabWidget.setCurrentIndex(i)
        zTab = self.tabWidget.currentWidget()
        zObjs = zTab.children()
        for j in range(len(zObjs)):
            if zObjs[j].accessibleName() == zCible :
               zObj = zObjs[j]
               return zObj
    return zObj

#==========================
# FUNCTIONS BUILDING LISTS
#==========================
def MakeListCountries(self):
    ListCountries, ListCountriesCode, indexCountry, zCible = [], {}, 0, ""
    isHD = False
    ZIPREG = {"UnitedStates" : ("^\d{5}([\-]?\d{4})?$","99999-9999;X"), \
              "United States" : ("^\d{5}([\-]?\d{4})?$","99999-9999;X"), \
              "UnitedKingdom"  : ("^[A-Z]{1,2}[0-9]{1,2}[A-Z]?\s[0-9][A-Z][A-Z]$","XXXXXXXX;X"), \
              "United Kingdom"  : ("^[A-Z]{1,2}[0-9]{1,2}[A-Z]?\s[0-9][A-Z][A-Z]$","XXXXXXXX;X"), \
              "Germany" : ("^(\d{5}$)", "99999;X"), \
              "Canada" : ("(^+[A-VXY][0-9][A-Z] +[0-9][A-Z][0-9]$)", "XXX XXX;X"), \
              "France" : ("(^(([0-8][0-9])|(9[0-5]))[0-9]{3}$)","99999;X") , \
              "Italy" : ("^(\d{5})$", "99999;X"), \
              "Italia" : ("^(\d{5}$)", "99999;X"), \
              "Australia" : ("^(\d{3})$", "999;X"), \
              "Netherlands" : ("^[0-9]{4} [A-Z]{2}", "9999XX;X"), \
              "Spain" : ("^(\d{5}$)", "99999;X"), \
              "Denmark" : ("^([D-d][K-k])?( |-)?[1-9]{1}[0-9]{3}$","X999;X"), \
              "Sweden" : ("^(\d{3} \d{2})$","999 99;X"), \
              "Belgium" : ("^[1-9]{1}[0-9]{3}$","9999;X"), \
              "India" : ("^\d{6}$","999999;X")
              } 

    if QtCore.QT_VERSION <= 263937 :
        isHD = False    
        langlocale = self.localeFullName
    else :
        isHD = True
        langlocale = []
        zLangLocaleFullName = self.localeFullName
        if zLangLocaleFullName.find("-")==-1: zLangLocaleFullName = zLangLocaleFullName.replace("-","_")
        if zLangLocaleFullName.find("_")==-1: zLangLocaleFullName+= "_%s" % (zLangLocaleFullName.upper())
        langlocale.append("%s" % (zLangLocaleFullName)) 

  
    for lid in range(QtCore.QLocale.C, QtCore.QLocale.LastLanguage + 1):
        lang = QtCore.QLocale.Language(lid)
        countries = QtCore.QLocale.countriesForLanguage(lang)
        for country in countries:
            locale = QtCore.QLocale(lang, country)
            
            if isHD : label = locale.nativeCountryName()    
            else : label = "%s" % (QtCore.QLocale.countryToString(country))
            
            if (label not in ListCountries and not label in ("", "Default")) :

               if langlocale == locale.name(): zCible = label
               if type(langlocale)== list :
                   if locale.name() in langlocale : zCible = label
               else :
                   if langlocale == locale.name(): zCible = label
               try :
                    ListCountries.append(label)
                    if ZIPREG.has_key(label) :
                       ListCountriesCode[label] = ZIPREG[label] 
                    else :  ListCountriesCode[label] = ("(^+[a-zA-Z_0-9\s]{3,10}$)","XXXxxxxxxx;X")  
               except : pass                     
    ListCountries.sort()
    
    if zCible != "" and zCible in ListCountries : indexCountry = ListCountries.index(zCible)
    return ListCountries, indexCountry, ListCountriesCode    

def MakeListLangues(self, zObj, mylang):
    myelts = ShortDic(self.languesDico)
    i = iIndex = 0
    for elt in myelts :
        if len(elt)==3 :
           zObj.addItem(self.languesDico[elt]['bibliographic'])
           if self.languesDico[elt]['english'] == mylang : iIndex = i
           i+= 1
    return iIndex

def MakeListTypeRessources(self):
    ListTypeRessources = (QtGui.QApplication.translate("QSphere","Spatial Dataset", None, QtGui.QApplication.UnicodeUTF8), \
                           QtGui.QApplication.translate("QSphere","Spatial data series", None, QtGui.QApplication.UnicodeUTF8), \
                           QtGui.QApplication.translate("QSphere","Spatial data service", None, QtGui.QApplication.UnicodeUTF8)
                  )
    return ListTypeRessources

def MakeListTemporalSystem(self):
    zListTemporalSystem = (QtGui.QApplication.translate("QSphere","Ethiopian", None, QtGui.QApplication.UnicodeUTF8), \
                           QtGui.QApplication.translate("QSphere","Gregorian", None, QtGui.QApplication.UnicodeUTF8), \
                           QtGui.QApplication.translate("QSphere","Hegirian", None, QtGui.QApplication.UnicodeUTF8), \
                           QtGui.QApplication.translate("QSphere","Persan", None, QtGui.QApplication.UnicodeUTF8), \
                           QtGui.QApplication.translate("QSphere","Vikram Samvat", None, QtGui.QApplication.UnicodeUTF8)
                  )
    return zListTemporalSystem
    

def MakeListEncoders(self):
    from encodings.aliases import aliases
    return aliases.keys()


def getRandowId(self):
    pop = string.ascii_letters + string.digits
    k=12
    generateId = ''.join( sample(pop, k) )
    today = datetime.datetime.now() 
    generateId+= today.strftime("_%m%d%HH%MM%SS")
    return generateId

def getisocodes_dict(data_path):
    data_path = os.path.dirname(__file__).replace("\\","/") +"/ressources/"+data_path
    D = {}
    if os.path.exists(data_path) :
        f = codecs.open(data_path, 'rb', 'utf-8')
        for line in f:
            iD = {}
            iD['bibliographic'], iD['terminologic'], iD['alpha2'], iD['english'], iD['french'] = line.strip().split('|')
            D[iD['bibliographic']] = iD
            if iD['terminologic']:  D[iD['terminologic']] = iD
            if iD['alpha2']: D[iD['alpha2']] = iD
            for k in iD: iD[k] = iD[k] or None
        f.close()
    return D

def MakeListFormats(self):
    zListFormats = {}
    for iDriver in range(ogr.GetDriverCount()):
        poDriver = ogr.GetDriver(iDriver)
        poValue = poDriver.GetName()
        driver = gdal.GetDriverByName("%s" % (poValue))
        zListFormats = SetEltListFormats(self, zListFormats, driver, poValue)

    for iDriver in range(gdal.GetDriverCount()):
        poDriver = gdal.GetDriver(iDriver)
        poValue = poDriver.ShortName
        driver = gdal.GetDriverByName("%s" % (poValue))
        zListFormats = SetEltListFormats(self, zListFormats, driver, poValue)

    zListitems, listeItems = ShortDic(zListFormats), ""    
    return zListitems

def SetEltListFormats(self, zListFormats, driver, poValue):
       if driver :
            poDriverMetadata = driver.GetMetadata()
            if poDriverMetadata.has_key(gdal.DMD_LONGNAME) :
               poFormat = poDriverMetadata[gdal.DMD_LONGNAME]
               zListFormats[poFormat]=poFormat
            elif poDriverMetadata.has_key(gdal.DMD_MIMETYPE) :
               poFormat = poDriverMetadata[gdal.DMD_MIMETYPE]
               zListFormats[poFormat]= poFormat
            elif poDriverMetadata.has_key(gdal.DMD_EXTENSION) :
               poFormat = poDriverMetadata[gdal.DMD_EXTENSION] 
               zListFormats[poFormat]= poFormat
       else : zListFormats[poValue]=poValue
       return zListFormats

def MakeListLangs(self):
    languages=[]
    myLangs = [QtCore.QLocale(lang).language() for lang in languages]
    for language in range(QtCore.QLocale.C, QtCore.QLocale.Chewa + 1):
        if language not in (QtCore.QLocale.C, QtCore.QLocale.Chewa + 1):
           if languages and (language not in languages): continue
           myLangs.append( language )
    return myLangs

def getUILangIndex(self):
    myLang = QLocale().language()
    myLangName = unicode( QtCore.QLocale.languageToString( myLang ))
    return myLang, myLangName

def ShortDic(zDic):
    keylist = zDic.keys()
    keylist.sort()
    return keylist

def ReLOADTableView(self, config, zObj, zSection):
    zInfos = config.get(zSection,'Indexes')
    zInfos = zInfos.rstrip()
    zInfosItem = config.get(zSection,'ItemCount')
    zItemCount = int(zInfosItem.rstrip())
    zDiff =  zObj.model().rowCount() - zItemCount
    if zSection == "tablelangues" :
        data_icons = os.path.dirname(__file__).replace("\\","/") +"/ressources/images/"
    
    if zDiff > 0 :
       while zDiff > 0 :
           zObj.model().removeRow(zObj.model().rowCount()-1)
           zDiff-= 1 
    
    for j in range(zItemCount):
        zValues = config.get(zSection,'Item_%s' % (j))
        zValuesTAB = None
        if zValues.find("|")!=-1: zValuesTAB = zValues.split("|")
        zColCount = len(zValuesTAB) if zValuesTAB != None else 1 
        for l in range(zColCount):
           if zSection == "tablelangues" :
              zIcon = QIcon("%s%s%s" % (data_icons, zValuesTAB[0], ".png"))
              item = QStandardItem() if l == 0 else QStandardItem(zIcon, "")
           else : item = QStandardItem()
           item.setText("%s" % (zValuesTAB[l])) if zValuesTAB != None else item.setText("%s" % zValues)
           if l == 0 :
               item.setCheckState(Qt.Unchecked)
               item.setCheckable(True)
           item.setEditable(False)
           zObj.model().setItem(j, l, item)

    if zInfos.find("|")!=-1 :
       zEltsDate = zInfos.split("|")
       for j in range(len(zEltsDate)): zObj.model().item(int(zEltsDate[j]), 0).setCheckState(Qt.Checked)
    else:
       if zInfos!="": zObj.model().item(int(zInfos), 0).setCheckState(Qt.Checked)
       

def ReLOADTableWidget(self, config, zObj, zSection):
    zTitle = "Information"
    zTest, zRows, zCols = AnaInfosObj(self, config, zObj, zSection)

    if zTest :
        if zCols != zObj.columnCount() :
            zMsg = QtGui.QApplication.translate("QSphere","Colunms number invalide for Object : ", None, QtGui.QApplication.UnicodeUTF8)
            SendMessage(self, zTitle , "%s%s" % (zMsg, zSection), QgsMessageBar.WARNING, 5)
        else :
            zTest = True
            if zObj.rowCount()>0 :
                for k in range(zCols) :
                    zInfos = config.get(zSection,'zWidget_%s' % (k))
                    zClassWidgetInfos = zInfos.rstrip().split("|")
                    if zObj.cellWidget(0, k)!= None :
                        zClassWidgetInfo = "%s" % (zClassWidgetInfos[0])
                        if zClassWidgetInfo != zObj.cellWidget(0, k).metaObject().className():
                           if zObj.cellWidget(0, k).metaObject().className() != "MySimpleWidgetLineEdit" :
                              zTest = False
                              break
                    
            if not zTest :
               zMsg = QtGui.QApplication.translate("QSphere","Sub-Widgets not support in the current version of QSphere for : " , None, QtGui.QApplication.UnicodeUTF8)
               SendMessage(self, zTitle , "%s%s" % (zMsg, zSection), QgsMessageBar.WARNING, 5)
            else :
                self.cleanAllObj(zObj, False)
                if zRows > 0 :
                    zItem = {}
                    for j in range(zRows):
                        zObj.insertRow(j)
                        zInfos = config.get(zSection,'zRow_%s' % (j))
                        zClassWidgetValues = zInfos.split("|")
                        if len(zClassWidgetValues)< zCols : break
                        
                        for k in range(zCols) :
                            zInfos = config.get(zSection,'zWidget_%s' % (k))
                            zClassWidgetInfos = zInfos.rstrip().split("|")
                            zClassWidgetInfo = "%s" % (zClassWidgetInfos[0])
                            if zClassWidgetInfo == "standard" :
                                zItem[k] = QTableWidgetItem()
                                zItem[k].setText("%s" % (zClassWidgetValues[k]))
                                zObj.setItem(j,k, zItem[k])
                            else :
                                if is_number_int(zClassWidgetValues[k]) and zClassWidgetInfos[0] not in("QLineEdit","MySimpleWidgetLineEdit", "MyWidgetLineEdit") : zValue = int(zClassWidgetValues[k])
                                elif is_number_float(zClassWidgetValues[k]) and zClassWidgetInfos[0] not in("QLineEdit", "MySimpleWidgetLineEdit", "MyWidgetLineEdit") : zValue = float(zClassWidgetValues[k])
                                else : zValue = "%s" % (zClassWidgetValues[k])

                                if int(zClassWidgetInfos[2])!= -1 : AddLineWidget(self, zObj, j,  k, int(zClassWidgetInfos[1]), int(zClassWidgetInfos[2]), zValue)                                      
                                else : AddLineWidget(self, zObj, j,  k, int(zClassWidgetInfos[1]), int(zClassWidgetInfos[2]), ("%s" % (zClassWidgetValues[k-1]), zValue))

                        if zObj.accessibleName() == "tableemprises":
                           zObj.setToolTip("%s" % (zObj.rowCount()-1))
                           self.DessCadre()

                        self.countItems(zObj.accessibleName(), zObj)   
          
    else :
        
        zMsg = QtGui.QApplication.translate("QSphere","Rows and Colunms not find for Object : ", None, QtGui.QApplication.UnicodeUTF8)
        SendMessage(self, zTitle , "%s%s" % (zMsg, zSection), QgsMessageBar.WARNING, 5)


def AnaInfosObj(self, config, zObj, zSection):
    zTest, zRows, zCols = False, 0, 0
    zInfos = config.get(zSection,'zRows').rstrip()
    if zInfos!="":
       if convertSTR(zInfos, "int") :
          zRows = int(zInfos)
          zInfos = config.get(zSection,'zCols').rstrip()
          if zInfos!="":
             if convertSTR(zInfos, "int") :
                zCols = int(zInfos)
                zTest = True
    return zTest, zRows, zCols


def AddLineWidget(self, zObj, zRow,  zCol, zWidget, zSubType, zDefaultValue):
        if zWidget == -1 :
            ObjWidget = MySimpleWidgetLineEdit() 
            zFullNameWidget = "%s_qlineedit_%s" % (zObj.accessibleName(), zRow)
            if zDefaultValue !="" : ObjWidget.setText(zDefaultValue)
    
        if zWidget == 0 :
            ObjWidget = MyWidgetLineEdit()
            ObjWidget.initType(zSubType)
            zFullNameWidget = "%s_mywidgetlineedit_%s" % (zObj.accessibleName(), zRow)
            if zSubType == 3 : ObjWidget.setInputMask("EPSG:999999;X")
            elif zSubType == 2 : ObjWidget.setInputMask("99999;X")
            elif zSubType == 1 : ObjWidget.setInputMask("9999-99-99 9999-99-99;X")
            elif zSubType == 5 : ObjWidget.setInputMask("9999-99-99;X")
            QtCore.QObject.connect(ObjWidget,QtCore.SIGNAL("textChanged(const QString &)"),ObjWidget.VerifExpReg) 
            ObjWidget.setText(zDefaultValue)
            
        if zWidget == 1 :
            ObjWidget = MyButton()
            zCond = True
            zFullNameWidget = "%s_mybutton_%s" % (zObj.accessibleName(), zRow)
            if zObj.accessibleName() == "tablescr" :
                zMsg = QtGui.QApplication.translate("QSphere","Call the SRS QGIS Dialog box", None, QtGui.QApplication.UnicodeUTF8)
                ObjWidget.initButton(40, 30, 0, 0, "proj_%s" % (zRow), "...", zMsg, zCond, False)
                QtCore.QObject.connect(ObjWidget,QtCore.SIGNAL("clicked()"),self.CallQgsProjectionSelector)
            else:
                zMsg = QtGui.QApplication.translate("QSphere","Call the QSphere Formats Dialog box", None, QtGui.QApplication.UnicodeUTF8)
                ObjWidget.initButton(40, 30, 0, 0, "format_%s" % (zRow), "...", zMsg, zCond, False)
                QtCore.QObject.connect(ObjWidget,QtCore.SIGNAL("clicked()"),self.CallFormatSelector)

        if zWidget == 2 :
           ObjWidget = QComboBox()
           zFullNameWidget = "%s_combobox_%s" % (zObj.accessibleName(), zRow)
           if zSubType == 0 :
               ObjWidget.addItems(self.ListOfRules)
               QtCore.QObject.connect(ObjWidget,QtCore.SIGNAL("currentIndexChanged(QString)"),self.CheckInfosRoles)
           elif zSubType == 1 :
               ObjWidget.addItems(self.ListOfThesaurus)
               zFullNameWidget = "%s_ListItems_%s" % (zObj.accessibleName(), zRow)
               QtCore.QObject.connect(ObjWidget,QtCore.SIGNAL("currentIndexChanged(QString)"),self.LoadListOfValues)
           elif zSubType == 2 : ObjWidget.addItems(self.ListTypeDates)
           elif zSubType == 3 : ObjWidget.addItems(self.ListDegres)
           elif zSubType == 4 : ObjWidget.addItems(self.ListFormats)
           elif zSubType == 5 :
               if not convertSTR(zDefaultValue, "int") :
                  if not zDefaultValue in self.listCountries : self.listCountries.append(u'%s' % (zDefaultValue))
                  zIndex = self.listCountries.index(u'%s' % (zDefaultValue))
               else : zIndex = zDefaultValue
               if zIndex < 0 : zIndex = 0
               ObjWidget.addItems(self.listCountries)
               ObjWidget.setEditable(True)
               ObjWidget.setCurrentIndex(zIndex)
               zFullNameWidget = "%s_ListItems_%s" % (zObj.accessibleName(), zRow)
               QtCore.QObject.connect(ObjWidget,QtCore.SIGNAL("currentIndexChanged(QString)"),self.ChangePatternZipPostalCode)
               
           elif zSubType == -1 :
               zTemp = zDefaultValue
               zDefaultValue = zTemp[1]
               SizeW, zCols, iLine = LoadFile(self, ObjWidget, "None", "file:200:thesaurus_%s.csv:0:0" % (zTemp[0]), 1, None)
           ObjWidget.setCurrentIndex(zDefaultValue) if not ObjWidget.isEditable() else ObjWidget.setCurrentIndex(zIndex)
           if zSubType == 0 and zRow < 2 : ObjWidget.setEnabled(False)

        if zWidget == 3 :
           zValue = (51.9, 41.36, -5.79, 9.56)
           zNameWidget = ("latituden", "latitudes", "longitudeo", "longitudee")
           ObjWidget = MySpinBox(zObj)  
           if zCol in (2,3): PropertiesDoubleSpinBox(self, ObjWidget, 8, -180, 180, 1)
           else : PropertiesDoubleSpinBox(self, ObjWidget, 8, -90, 90, 1)
           zFullNameWidget = "%s_%s_%s" % (zObj.accessibleName(), zNameWidget[zCol], zRow)
           if zDefaultValue==-1 : ObjWidget.setValue(zValue[zCol])
           else : ObjWidget.setValue(zDefaultValue)
           ObjWidget.setMouseTracking(True)
           QtCore.QObject.connect(ObjWidget, QtCore.SIGNAL("valueChanged(double)"), self.DessCadre)

        if zWidget == 4 :
           ObjWidget = QDoubleSpinBox()
           zFullNameWidget = "scalebox%s" % (zRow)
           if zObj.parent().children()[0].isChecked(): 
               PropertiesDoubleSpinBox(self, ObjWidget, 0, 0, 10000000, 1000)
               if zDefaultValue==-1 : ObjWidget.setValue(25000)
               else : ObjWidget.setValue(zDefaultValue)
           else:
               PropertiesDoubleSpinBox(self, ObjWidget, 4, 0, 1000, 10)
               if zDefaultValue==-1 : ObjWidget.setValue(float(2.0))
               else : ObjWidget.setValue(zDefaultValue)

        if zWidget == 5 :
           ObjWidget = QPushButton()  
           zFullNameWidget = "%s_action_%s" % (zObj.accessibleName(), zRow)
           myPathIconvView = getThemeIcon("voir.png")
           ObjWidget.setToolTip(QtGui.QApplication.translate("QSphere","View with WMS service the current extent", None, QtGui.QApplication.UnicodeUTF8))
           ObjWidget.setStyleSheet( """QPushButton { qproperty-icon: url("""+myPathIconvView+""");}"""
                          """QPushButton:pressed { qproperty-icon: url("""+myPathIconvView+""");}"""
                          """QPushButton:hover { qproperty-icon: url("""+myPathIconvView+""");}"""
                         )           
           QtCore.QObject.connect(ObjWidget, QtCore.SIGNAL("clicked()"), self.LoadGeoLocalisator) #DessCadre)

        if zWidget == 6 :
           ObjWidget = QCheckBox()
           zFullNameWidget = "%s_action_%s" % (zObj.accessibleName(), zRow)
           ObjWidget.setToolTip(QtGui.QApplication.translate("QSphere","From controlled Vocabulary ", None, QtGui.QApplication.UnicodeUTF8))
           QtCore.QObject.connect(ObjWidget, QtCore.SIGNAL("toggled(bool)"), self.ChangeAccessibility)
           if type(zDefaultValue)!= int : zDefaultValue = 2
           ObjWidget.setCheckState(zDefaultValue) 

        if zWidget == 7 :
            if zObj.accessibleName() in ("tableformats","tablelocalisator", "tablescr"):
               typeObj = 6
               zIcon = getThemeIcon("supprimer.png") if zRow > 0 else getThemeIcon("supprimernone.png")
               zToolTip = QtGui.QApplication.translate("QSphere","Delete the current line", None, QtGui.QApplication.UnicodeUTF8) if zRow > 0 else QtGui.QApplication.translate("QSphere","Can't delete the first line", None, QtGui.QApplication.UnicodeUTF8)
            zNameButton = "Effacer_%s_%s_%s" % (typeObj, zObj.accessibleName(), zRow)
            
            ObjWidget = MyPushButton()
            ObjWidget.initPushButton(24, 24, 0, 0, zNameButton, "", zToolTip, True, zIcon, 24, 24, True)
            zFullNameWidget = "%s_mypushbutton_%s" % (zObj.accessibleName(), zRow)

            if zObj.accessibleName() in ("tableformats","tablelocalisator", "tablescr"):
               QtCore.QObject.connect(ObjWidget, QtCore.SIGNAL("clicked()"), self.DelLineIndex) if zRow > 0 else QtCore.QObject.connect(ObjWidget, QtCore.SIGNAL("clicked()"), self.DelLine)

        ObjWidget.setObjectName(zFullNameWidget) 
        ObjWidget.setAccessibleName(zFullNameWidget)
        ObjWidget.setAccessibleDescription("%s|%s" % (zWidget, zSubType))  
        zObj.setCellWidget(zRow, zCol, ObjWidget)


def PropertiesDoubleSpinBox(self, zObj, zDec, zMin, zMax, zStep):
        zObj.setDecimals(zDec)                
        zObj.setMinimum(zMin)
        zObj.setMaximum(zMax)                
        zObj.setSingleStep(zStep)

def ReturnDate(self, zObj):
    pydate = zObj.selectedDate()
    TheDate = "%s" % (pydate.toString('yyyy-MM-dd'))
    return TheDate            

def LoadFile(self, zObj, nameObj, zCible, typeObj, zModel):
    zPath = os.path.dirname(__file__)
    zPath = zPath.replace("\\","/")
    zCible = zCible.split(":")    
    zFileCSV = zPath +"/ressources/"+zCible[2]
    zUseModel = int(zCible[3])
    zUseIcons = int(zCible[4])

    iLine, zCols = 0, 0
    if zModel == None : zModel = QStandardItemModel()
    if os.path.exists(zFileCSV) :
       f = open(zFileCSV, "r")
       while 1:
           zText = f.readline()
           if zText == "" : break
           if nameObj == "langmetada" : print(zText)
           
           zValue = zText.split(";")
           if zCols == 0 : zCols = len(zValue)
           if zUseModel == 1 :
               if nameObj == "tablegroupedroits" : zToolTip = zValue[1].replace("\"","").replace(",","\n").replace(":",":\n").rstrip()
               for i in range(zCols):
                   item = QStandardItem(True)
                   zTextItem = zValue[i].replace("\"","").rstrip()
                   item.setText(zTextItem)
                   if i == 0 and typeObj == 3:    
                      item.setCheckable(True)
                      item.setCheckState(Qt.Unchecked)
                      if nameObj == "tablelangues" and zTextItem.startswith(self.langueTR): item.setCheckState(Qt.Checked)
                      
                   if nameObj == "tablegroupedroits" : item.setToolTip(zToolTip) 
                          
                   if i > 0 : item.setSelectable(False)
                   item.setEditable(False)
                   zModel.setItem(iLine, i ,item)
           else:
               if  typeObj == 1:
                   zVal = ("%s" % (zValue[0]))
                   zVal = zVal.replace("\"","").rstrip()
                   if zUseIcons == 1 :
                       menuIcon = getLangIcon(zVal+".png")
                       zObj.addItem(QIcon(menuIcon), zValue[1].replace("\"","").rstrip(), "%s" % (zVal) )
                   else :    
                       zObj.addItem("%s" % (zVal)) 
           iLine+= 1         
       f.close()

    if zUseModel == 1 :   
        view = QTableView()
        view.horizontalHeader().setVisible(False) 
        view.verticalHeader().setVisible(False)
        view.horizontalHeader().setResizeMode(QHeaderView.ResizeToContents)
        view.setSelectionBehavior(QAbstractItemView.SelectRows)
        view.setSelectionMode(QAbstractItemView.SingleSelection)
        select = view.selectionModel()

        if typeObj == 1 :
            zObj.setView(view)
            zObj.setModel(zModel)
            zObj.show()

        if nameObj == "tablecategories" : QtCore.QObject.connect(zModel, QtCore.SIGNAL("itemChanged(QStandardItem*)"), self.SelectKeyWord)

    return int(zCible[1]), zCols, iLine
#--------------------------
#FUNCTION TO MAKEWINDOWICO
#--------------------------
def MakeWindowIcon(qtWindow, sIcon):
        zIcon = getThemeIcon(sIcon)
        if zIcon != "" : qtWindow.setWindowIcon(QIcon(zIcon)) 

#--------------------------------------
# FUNCTIONS FOR CORRECTION IMAGES PATH 
#--------------------------------------
def getThemeIcon(theName):
    myPath = CorrigePath(os.path.dirname(__file__));
    myPath = myPath.replace("\\","/")
    myDefPath = myPath + theName;
    myDefPathIcons = myPath + "icons/"+ theName;
    myCurThemePath = QgsApplication.activeThemePath() + "/plugins/" + theName;
    myDefThemePath = QgsApplication.defaultThemePath() + "/plugins/" + theName;
    myProfilPath = QgsApplication.qgisSettingsDirPath() + "python/plugins/qsphere/";
    myQrcPath =  "python/plugins/qsphere/" + theName;
    if QFile.exists(myDefPathIcons): return myDefPathIcons
    elif QFile.exists(myDefPath): return myDefPath
    elif QFile.exists(myCurThemePath): return myCurThemePath
    elif QFile.exists(myDefThemePath): return myDefThemePath
    elif QFile.exists(myProfilPath) : return myProfilPath 
    elif QFile.exists(myQrcPath): return myQrcPath
    elif QFile.exists(theName): return theName
    else: return ""

def getLangIcon(theName):
    myPath = CorrigePath(os.path.dirname(__file__)) 
    myDefPath = myPath.replace("\\","/")
    myRessourcesPath = myDefPath + "/ressources/images/"  
    if QFile.exists(myRessourcesPath +  theName): return myRessourcesPath + theName
    elif QFile.exists(myRessourcesPath +  "vide.png"): return myRessourcesPath + "vide.png"
    else: return theName


def CorrigePath(nPath):
    nPath = "%s" % (nPath)
    a = len(nPath)
    subC = "/"
    b = nPath.rfind(subC, 0, a)
    return (nPath + "/") if a != b else nPath 

#-------------------------------------
# FUNCTIONS LOADER IMAGES FOR QSPHERE 
#-------------------------------------
def listdirectory(self, path):
    LstImages = "<table class='comment'>"
    for dirname, dirnames, filenames in os.walk(path):
        for filename in filenames: LstImages+= scandirectory(self, os.path.join(dirname, filename))
    LstImages+= "</table>"    
    return LstImages       
            
def scandirectory(self, currentFile):
    zHTML = ""
    if os.path.exists(currentFile):
        if os.path.isfile(currentFile):
           zName = "%s" % (os.path.basename(currentFile))
           textension = os.path.splitext(currentFile)
           extension = textension[len(textension)-1].lower()
           if zName.find("qsphere_")!=-1 and extension!="" and extension == ".png":
              zHTML = "<tr><td><img src='%s/%s'></td><td>%s</td></tr>" % (os.path.dirname(currentFile), zName, zName)
    return zHTML

def IsCorrectLayer(layer, zEnc):
    if not layer: return False
    if not layer.type() == layer.VectorLayer: return False
    if not layer.isValid() : return False
    if not zEnc :
        if layer.geometryType() != QGis.Point and layer.geometryType() != QGis.Line and layer.geometryType() != QGis.Polygon: return False
    else:
        if not layer.geometryType() == QGis.Point : return True
    return True

#-------------------------------------------------
#FUNCTION TEST IF NUMBER TYPE INT OR SUPPORT FLOAT
#-------------------------------------------------     
def is_number_float(s):
    try:
        float(s)
        return True
    except ValueError:
        return False

#-----------------------------------------------
#FUNCTION TEST IF NUMBER TYPE INT OR SUPPORT INT
#-----------------------------------------------    
def is_number_int(s):
    try:
        int(s)
        return True
    except ValueError:
        return False

#---------------------------------------
#FUNCTION TEST IF EXP IS A VALID NUMBER    
#---------------------------------------
def IsValideNumber(s, isCoord) :
    if not s : return "F"
    if is_number_int(s) :
       if s == 0 or (s == -9999 and isCoord) : return "F"
       else : return "T"
    if is_number_float(s) :
       if s == 0.0 or (s == -9999.0 and isCoord) : return "F"
       else : return "T"

#---------------------------------
#FUNCTION TEST CONVERT EXPRESSION   
#---------------------------------
def convertSTR(s, zType):
    if zType == "int" :
        try :
            zText = int(s)
            return True
        except : return False
    elif zType == "float" :        
        try :
            zText = float(s)
            return True
        except : return False
    else: return False


#---------------------------------
#FUNCTION TEST IF NUMBER TYPE FLOAT 
#---------------------------------   
def is_number_reallyfloat(s): return (type(s)== float) 

#-----------------------------------
#FUNCTION TEST IF NUMBER TYPE INT 
#-----------------------------------     
def is_number_reallyint(s): return (type(s)== int)

#------------------------
# FUNCTION QGSMESSAGEBAR
#------------------------
def SendMessage(self, zTitle , zMsg, zLevel, zDuration): self.barInfo.pushMessage(zTitle, zMsg, zLevel, zDuration)
