# -*- coding:utf-8 -*- 
from PyQt4 import QtCore, QtGui
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import * 
from PyQt4.QtGui import * 
from qgis.core import *
from qgis.gui import *
from datetime import date
from qsphere_tools import *

#-------------------------
# CLASSES
#-------------------------
class SRSDialog(QDialog): 
       def __init__(self): 
         QDialog.__init__(self) 
         layout = QVBoxLayout(self) 
         self.selector = QgsProjectionSelector(self)
         self._W, self._H = 500, 600
         self.setMinimumSize(QtCore.QSize(self._W,self._H)) 
         buttonBox = QDialogButtonBox(QDialogButtonBox.Ok | QDialogButtonBox.Close) 
         self.connect(buttonBox, SIGNAL("accepted()"), self.accept) 
         self.connect(buttonBox, SIGNAL("rejected()"), self.reject) 
         layout.addWidget(self.selector) 
         layout.addWidget(buttonBox) 
         self.setLayout(layout) 
  
       def epsg(self):
         QGISVersionID = 0
         try: QGISVersionID = int(unicode( QGis.QGIS_VERSION_INT ))
         except: QGISVersionID = int(unicode( QGis.qgisVersion )[ 0 ])
         zCRS = self.selector.selectedEpsg() if QGISVersionID < 10900 else self.selector.selectedAuthId()
         return zCRS 

class FormatDialog(QDialog):
       def  __init__(self, listformats):
         QDialog.__init__(self)
         self.setWindowTitle("Formats GDAL/OGR")
         self._W, self._H = 500, 300
         self.setMinimumSize(QtCore.QSize(self._W,self._H))         
         layout = QVBoxLayout(self)
         self.gdalogrformats = listformats
         self.listformats = QListView(self)
         self.listformats.setGeometry(QtCore.QRect(10, 10, 200, 400))
         self.modele = QStringListModel()
         self.modele.setStringList(self.gdalogrformats)
         self.listformats.setModel(self.modele)
         self.listformats.setSelectionMode(QAbstractItemView.SingleSelection)
         self.listformats.setEditTriggers(QAbstractItemView.NoEditTriggers)
         buttonBox = QDialogButtonBox(QDialogButtonBox.Ok | QDialogButtonBox.Close) 
         self.connect(buttonBox, SIGNAL("accepted()"), self.accept) 
         self.connect(buttonBox, SIGNAL("rejected()"), self.reject) 
         layout.addWidget(self.listformats) 
         layout.addWidget(buttonBox) 
         self.setLayout(layout)

         QtCore.QObject.connect(self.listformats, SIGNAL("doubleClicked(QModelIndex)"), self.accept)

       def format(self):
         selection = self.listformats.selectionModel()
         indexElementSelectionne = int(selection.currentIndex().row())
         return "%s" % (self.gdalogrformats[indexElementSelectionne])     

class TopologyDialog(QDialog):
       def  __init__(self, dictinfosTopology):
         QDialog.__init__(self)
         self.setWindowTitle(QtGui.QApplication.translate("QSphere","Topology informations :", None, QtGui.QApplication.UnicodeUTF8))
         layout = QVBoxLayout(self)
         self._W, self._H = 400, 160
         self.setMinimumSize(QtCore.QSize(self._W,self._H))         
         self.zoneInfos = QTableWidget(0, 2, self)
         self.zoneInfos.setObjectName("zoneInfos")
         self.zoneInfos.setAccessibleName("zoneInfos")
         self.zoneInfos.setGeometry(QtCore.QRect(10, 10, 300, 130))

         self._listTopo = ("abstract", "full planar graph", "full surface graph", "full topology 3D", "geometryOnly", "planar graph", "surface graph", "topology1D", "topology3D", "unknow")
         self._listTypeVect = ("complex", "composite", "curve", "point", "solid", "surface","unknow")
         
         import ast
         try : mydict = ast.literal_eval("%s" % (dictinfosTopology))
         except : mydict = None
         if mydict!= None and type(mydict)== dict :
            zIndexTopo = self._listTopo.index(mydict['TopologyLevelCode']) if mydict.has_key('TopologyLevelCode') else 0
            zIndexTypeVect = self._listTypeVect.index(mydict['GeometricObjectTypeCode']) if mydict.has_key('GeometricObjectTypeCode') else 0    

         zDim = (160, 200)
         for i in range(len(zDim)): self.zoneInfos.setColumnWidth(i, zDim[i])         
         self.zoneInfos.verticalHeader().setVisible(False)
         self.zoneInfos.horizontalHeader().setVisible(False)

         self.zoneInfos.insertRow(0)

         ObjWidget = QLineEdit()
         ObjWidget.setMinimumSize(QtCore.QSize(160, 30))
         ObjWidget.setMaximumSize(QtCore.QSize(160, 30))
         ObjWidget.setText("TopologyLevelCode")
         ObjWidget.setEnabled(False)
         self.zoneInfos.setCellWidget(0, 0, ObjWidget)

         ObjWidget = QComboBox()
         ObjWidget.setMinimumSize(QtCore.QSize(200, 30))
         ObjWidget.setMaximumSize(QtCore.QSize(200, 30))
         ObjWidget.addItems(self._listTopo)
         ObjWidget.setCurrentIndex(zIndexTopo)
         self.zoneInfos.setCellWidget(0, 1, ObjWidget)

         self.zoneInfos.insertRow(1)

         ObjWidget = QLineEdit()
         ObjWidget.setMinimumSize(QtCore.QSize(160, 30))
         ObjWidget.setMaximumSize(QtCore.QSize(160, 30))
         ObjWidget.setText("GeometricObjectTypeCode")
         ObjWidget.setEnabled(False)
         self.zoneInfos.setCellWidget(1, 0, ObjWidget)

         ObjWidget = QComboBox()
         ObjWidget.setMinimumSize(QtCore.QSize(200, 30))
         ObjWidget.setMaximumSize(QtCore.QSize(200, 30))
         ObjWidget.addItems(self._listTypeVect)
         ObjWidget.setCurrentIndex(zIndexTypeVect)
         self.zoneInfos.setCellWidget(1, 1, ObjWidget)

         buttonBox = QDialogButtonBox(QDialogButtonBox.Ok | QDialogButtonBox.Close) 
         self.connect(buttonBox, SIGNAL("accepted()"), self.accept) 
         self.connect(buttonBox, SIGNAL("rejected()"), self.reject) 
         layout.addWidget(self.zoneInfos) 
         layout.addWidget(buttonBox) 
         self.setLayout(layout)


       def infosTopology(self):
         return "{'TopologyLevelCode':'%s', 'GeometricObjectTypeCode':'%s'}" % (self.zoneInfos.cellWidget(0, 1).currentText(), self.zoneInfos.cellWidget(1, 1).currentText())

class MySimpleWidgetLineEdit(QLineEdit):
      def __init__(self, *args):
          QLineEdit.__init__(self, *args)
          
      def focusInEvent(self, event):
          try :
                 CurrentRow = int(self.objectName().split("_")[2])
                 zTableWidget = self.parent().parent()
                 zTableWidget.selectRow(CurrentRow)
          except : pass
          
class MyWidgetLineEdit(QLineEdit):
      def __init__(self, *args):
          QLineEdit.__init__(self, *args)
 
      def initType(self, iType):
          if iType == 0 : self.regex = QRegExp(r"(^[\w.-]+@[\w.-]+\.[a-zA-Z]{2,6}$)", Qt.CaseSensitive)
          elif iType == 2 : self.regex = QRegExp(r"(^(([0-8][0-9])|(9[0-5]))[0-9]{3}$)", Qt.CaseSensitive)
          elif iType == 3 : self.regex = QRegExp(r"(^EPSG:+[0-9]{4,6}$)", Qt.CaseSensitive)
          elif iType == 4 : self.regex = QRegExp(r"^(http|https|ftp)\://[a-zA-Z0-9\-\.]+.[\w]{2,4}(:[a-zA-Z0-9]*)?/?([a-zA-Z0-9\-\._\?\,\'/\\\+&amp;%\$#\=~])*$", Qt.CaseSensitive)
          self.setStyleSheet("background-color:red;") if iType != 3 else self.setStyleSheet("background-color:#AEEE00;")
          self.iType = iType

      def focusInEvent(self, event):
          try :
                 CurrentRow = int(self.objectName().split("_")[2])
                 zTableWidget = self.parent().parent()
                 zTableWidget.selectRow(CurrentRow)
          except : pass
          
      def keyPressEvent(self, event):
          if event.key() == QtCore.Qt.Key_Return or event.key() == QtCore.Qt.Key_Enter :
             if self.parent().accessibleName() == "DialogViewer" :    
                zDialog = self.parent()
                zDialog.go_url()
                return
          QLineEdit.keyPressEvent(self,event)

      def VerifExpReg(self):          
          self.setStyleSheet("background-color:red;")
          if self.iType in (0, 3, 4):
             zCond = False    
             if self.iType in (0, 4):
                zCond = True
                if self.iType == 4 and self.text().find(" ")!= -1 :   self.setText(self.text().replace(" ","%20"))    
             else :
                 zText = self.text().replace("EPSG:","")
                 if zText != "" :
                        zId = long(zText)
                        zCond = QgsCoordinateReferenceSystem().createFromSrid(zId)
             if self.regex.exactMatch(self.text()) and zCond : self.setStyleSheet("background-color:#AEEE00;")
          elif self.iType == 6 :
             if self.text()!= "" : self.setStyleSheet("background-color:#AEEE00;")   
          elif self.iType == 5 :
             zDate = self.text()
             zTestDate1 = verifdatechaine(zDate, "-")
             if zTestDate1 : self.setStyleSheet("background-color:#AEEE00;")
          elif self.iType == 1 :              
             zDateInf = self.text().split(" ")[0]
             zDateSup = self.text().split(" ")[1]
             zTestDate1 = verifdatechaine(zDateInf, "-")
             zTestDate2 = verifdatechaine(zDateSup, "-")
             if zTestDate1 and zTestDate2:
                L = zDateInf.split("-")
                a, m, j = int(L[0]), int(L[1]), int(L[2])
                d0 = date(a, m, j)
                L = zDateSup.split("-")
                a, m, j = int(L[0]), int(L[1]), int(L[2])
                d1 = date(a, m, j)
                delta = d1 - d0
                if (delta.days)>=0 : self.setStyleSheet("background-color:#AEEE00;")

                
          if self.iType == 2 :
              if self.regex.exactMatch(self.text()):
                 if self.regex.pattern() == "(^(([0-8][0-9])|(9[0-5]))[0-9]{3}$)" :
                    if self.text()!="00000" : self.setStyleSheet("background-color:#AEEE00;") #and self.text()!="00000" #A remettre
                 else : self.setStyleSheet("background-color:#AEEE00;")

class MyLabel(QLabel):
     def __init__(self, *args):
             QLabel.__init__(self, *args)
             self.setStyleSheet("QLabel { border-top : 1px solid yellow;  border-bottom : 1px solid yellow;  border-left: 1px solid yellow;  border-right : 1px solid yellow }")
             self.setWindowOpacity(0.5)
             self.setAutoFillBackground(False)
             self.setUpdatesEnabled(True)
    

class MyButton(QPushButton):
     def __init__(self, *args):
            QPushButton.__init__(self, *args)
            
     def initButton(self, SizeW, SizeH, zPosX, zPosY, zName, zText, zToolTip, zEnable, zGeom):
            self.setMinimumSize(QtCore.QSize(SizeW, SizeH))
            self.setMaximumSize(QtCore.QSize(SizeW, SizeH))
            if zGeom : self.setGeometry(QtCore.QRect(zPosX, zPosY, SizeW, SizeH))
            self.setObjectName(zName)
            self.setAccessibleName(zName)
            self.setToolTip("%s" % (zToolTip))
            self.setText(zText)
            self.setEnabled(zEnable)

class MyPushButton(QPushButton):
     def __init__(self, *args):  QPushButton.__init__(self, *args)
            
     def initPushButton(self, zSizeW, zSizeH, zPosX, zPosY, zName, zText, zToolTip, zGeom, zIcon, zSizeWIcon, zSizeHIcon, zStyleSheet):
            self.setMinimumSize(QtCore.QSize(zSizeW, zSizeH))
            self.setMaximumSize(QtCore.QSize(zSizeW, zSizeH))
            if zGeom : self.setGeometry(QtCore.QRect(zPosX, zPosY, zSizeW, zSizeH))
            if zIcon != "" :
               self.setIcon(QIcon(zIcon))
               self.setIconSize(QSize(zSizeWIcon, zSizeHIcon))
            self.setToolTip(zToolTip)
            if zStyleSheet : self.setStyleSheet(""" QPushButton {border: none;}""")
            self.setObjectName(zName)
            self.setAccessibleName(zName)
            if zText != "" : self.setText(zText)


class MySpinBox(QDoubleSpinBox):
     def __init__(self, parent):
            QDoubleSpinBox.__init__(self, parent)
            self.parent = parent
            self.setFocusPolicy(QtCore.Qt.StrongFocus)
            self.installEventFilter(self)

     def eventFilter(self, object, event):
          if not event : return False
          if event == None : return False
          if event.type() == QEvent.FocusIn:
             zIndexEmp = int(object.accessibleName().split("_")[2])
             try :
                 self.parent.setToolTip("%s" % (zIndexEmp))
                 if self.parent.metaObject().className()=="QTableWidget" : self.parent.selectRow(zIndexEmp)
                 return True
             except : return False
          else : return False


class MyTextEdit(QTextEdit):           
     def __init__(self, *args): QTextEdit.__init__(self, *args)
            
     def initTextEdit(self, SizeW, SizeH, zPosX, zPosY, zName, zGeom, zUndoRedo, zReadOnly, zRichText):
            self.setMinimumSize(QtCore.QSize(SizeW, SizeH))
            self.setMaximumSize(QtCore.QSize(SizeW, SizeH))
            if zGeom : self.setGeometry(QtCore.QRect(zPosX, zPosY, SizeW, SizeH))
            self.setUndoRedoEnabled(zUndoRedo)
            self.setReadOnly(zReadOnly)
            self.setAcceptRichText(zRichText)
            self.setObjectName(zName)
            self.setAccessibleName(zName)

class MyProgressBar(QProgressBar):
     def __init__(self, *args): QProgressBar.__init__(self, *args)

     def initTextEdit(self, SizeW, SizeH, zPosX, zPosY, zName, zGeom, zInitValue, zViewText, zAlign, zStyleSheet):
            self.setMinimumSize(QtCore.QSize(SizeW, SizeH))
            self.setMaximumSize(QtCore.QSize(SizeW, SizeH))
            if zGeom : self.setGeometry(QtCore.QRect(zPosX, zPosY, SizeW, SizeH))          
            self.setProperty("value", zInitValue)
            self.setAlignment(zAlign)
            self.setTextVisible(zViewText)
            self.setObjectName(zName)
            self.setAccessibleName(zName)
            if zStyleSheet == 0 :
                 self.setStyleSheet(
                      """QProgressBar {border: 2px solid grey; border-radius: 5px; text-align: center;}"""
                      """QProgressBar::chunk {background-color: #6C96C6; width: 10px; margin: 0.5px;}"""
                  )

class MyListView(QListView):           
     def __init__(self, *args): QListView.__init__(self, *args)
            
     def initListView(self, SizeW, SizeH, zPosX, zPosY, zName, zGeom):
            self.setMinimumSize(QtCore.QSize(SizeW, SizeH))
            self.setMaximumSize(QtCore.QSize(SizeW, SizeH))
            if zGeom : self.setGeometry(QtCore.QRect(zPosX, zPosY, SizeW, SizeH))
            self.setObjectName(zName)
            self.setAccessibleName(zName)
            zFontStyle = "font: 9pt \"%s\";" % (QFont().defaultFamily())
            self.setStyleSheet(zFontStyle)

class MyListWidget(QListWidget):           
     def __init__(self, *args): QListWidget.__init__(self, *args)
            
     def initListWidget(self, SizeW, SizeH, zPosX, zPosY, zName, zGeom):
            self.setMinimumSize(QtCore.QSize(SizeW, SizeH))
            self.setMaximumSize(QtCore.QSize(SizeW, SizeH))
            if zGeom : self.setGeometry(QtCore.QRect(zPosX, zPosY, SizeW, SizeH))
            self.setObjectName(zName)
            self.setAccessibleName(zName)
            zFontStyle = "font: 9pt \"%s\";" % (QFont().defaultFamily())
            self.setStyleSheet(zFontStyle)

class MyTreeView(QTreeView):
     def __init__(self, *args): QTreeView.__init__(self, *args)

     def initTreeView(self, SizeW, SizeH, zPosX, zPosY, zName, zGeom, zDragDropMode, zHeaderHidden, zWordWrap, zEditTriggers, zStyleSheet):
            self.setMinimumSize(QtCore.QSize(SizeW, SizeH))
            self.setMaximumSize(QtCore.QSize(SizeW, SizeH))
            if zGeom : self.setGeometry(QtCore.QRect(zPosX, zPosY, SizeW, SizeH))
            self.setDragDropMode(zDragDropMode)
            self.setHeaderHidden(True)
            self.setWordWrap(True)
            self.setEditTriggers(zEditTriggers)
            self.setObjectName(zName)
            self.setAccessibleName(zName)
            if zStyleSheet == 0 :
                 myPathIconvLine = getThemeIcon("vline.png") 
                 myPathIconBranchMore = getThemeIcon("branch-more.png")
                 myPathIconBranchEnd = getThemeIcon("branch-end.png") 
                 myPathIconBranchClosed = getThemeIcon("branch-closed.png")
                 myPathIconBranchOpen = getThemeIcon("branch-open.png") 
                 
                 self.setStyleSheet(
                      """QTreeView  {show-decoration-selected: 1;}"""
                      """QTreeView::title {}"""
                      """QTreeView::item  {border: 1px solid #d9d9d9; border-top-color: transparent; border-bottom-color: transparent;}"""
                      """QTreeView::item:hover  {background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #e7effd, stop: 1 #cbdaf1); border: 1px solid #bfcde4;}"""
                      """QTreeView::item:selected  {border: 1px solid #567dbc;}"""
                      """QTreeView::item:selected:active {background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #6ea1f1, stop: 1 #567dbc);}"""
                      """QTreeView::item:selected:!active  { background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1, stop: 0 #6b9be8, stop: 1 #577fbf);}"""
                      """QTreeView::item {margin: 5px;}"""
                      """QTreeView::branch:has-siblings:!adjoins-item  {border-image: url("""+myPathIconvLine+""") 0;}"""
                      """QTreeView::branch:has-siblings:adjoins-item  {border-image: url("""+myPathIconBranchMore+""") 0;}"""
                      """QTreeView::branch:!has-children:!has-siblings:adjoins-item  {border-image: url("""+myPathIconBranchEnd+""") 0;}"""
                      """QTreeView::branch:has-children:!has-siblings:closed, QTreeView::branch:closed:has-children:has-siblings  {border-image: none; image: url("""+myPathIconBranchClosed+""");}"""
                      """QTreeView::branch:open:has-children:!has-siblings,QTreeView::branch:open:has-children:has-siblings   { border-image: none; image: url("""+myPathIconBranchOpen+""");}"""
                  )



#----------------
# FUNCTIONS DATE 
#----------------
def bissextile(an):
    if (an % 4)==0:
        if ((an % 100)==0) and ((an % 400)<>0): return False
        else: return True
    else: return False
 
def verifdate(j,m,a):
    # correction for short date year (eg.: '09' ald '2009')
    if a<100:
        if a<0: return False  
        if a<50: a += 2000  
        else: a += 1900  
    if m<1 or m>12 or j<1: return False
    if j>(31,29,31,30,31,30,31,31,30,31,30,31)[m-1]: return False
    if (not bissextile(a)) and m==2 and j>28: return False
    return True
 
def verifdatechaine(D, sep="/"):
    L = D.split(sep)
    if len(L)!=3: return False
    try: a, m, j = int(L[0]), int(L[1]), int(L[2])
    except: return False
    return verifdate(j,m,a)
