# -*- coding:utf-8 -*- 
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from ui_catalogue import Ui_Dialog_Metadata
from qsphere_tools import *
from ViewerHelp import Ui_Dialog
import os
import time 

class MovieSplashScreen(QSplashScreen):
     def __init__(self, movie, parent = None):
         movie.jumpToFrame(0)
         pixmap = QPixmap(movie.frameRect().size())
        
         QSplashScreen.__init__(self, pixmap)
         self.movie = movie
         self.movie.frameChanged.connect(self.repaint)
     
     def showEvent(self, event): self.movie.start()
     def hideEvent(self, event): self.movie.stop()
     def sizeHint(self): return self.movie.scaledSize()
     
     def paintEvent(self, event):
         painter = QPainter(self)
         pixmap = self.movie.currentPixmap()
         self.setMask(pixmap.mask())
         painter.drawPixmap(0, 0, pixmap)
     

class DialogViewer(QDialog, Ui_Dialog):
	def __init__(self, iface, zUrl, isXML, zEmprise):
		QDialog.__init__(self)
		self.setModal(False)
		self.setObjectName("DialogViewer")
                self.setAccessibleName("DialogViewer")
		self.iface = iface
		self.url = zUrl
		self.isXML = isXML
		self.emprise = zEmprise		
		self.setupUi(self)
		
		
class DialogMetadata(QDialog, Ui_Dialog_Metadata):
	def __init__(self, iface, langue, languageindex, langs, langsdico, langueTR, formats, listCodecs, \
                     listTemporalSystem, listTypeRessources, listCountries, indexCountry, listCountriesCode, \
                     localeFullName):
                zMovie = getThemeIcon("animation.gif")
                zCond = os.path.exists(zMovie)
                if zCond :
                        movie = QMovie(zMovie)
                        splash = MovieSplashScreen(movie)
                        splash.show()
                        start = time.time()
                        while movie.state() == QMovie.Running and time.time() < start + 1: QApplication.processEvents()
                
                QDialog.__init__(self)
             
                self.setObjectName("DialogMetadata")
                self.setAccessibleName("DialogMetadata")
                self.iface = iface
                self.langue = langue
                self.languageindex = languageindex
                self.langs = langs
                self.languesDico = langsdico
                self.langueTR = langueTR
                self.formats = formats
                self.listCodecs = listCodecs
                self.listTemporalSystem = listTemporalSystem
                self.listTypeRessources = listTypeRessources
                self.listCountries = listCountries
                self.indexCountry = indexCountry
                self.localeFullName = localeFullName
                self.listCountriesCode = listCountriesCode
                self.setupUi(self)

                if zCond : splash.finish(self)
               
                

               
